﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareIntermediate
{
    using System;
    using System.Collections.Generic;
    using Core.Parameters;
    using Projects;
    using ToolDevelopmentKit;

    public class CommonItemParamTranslator : ItemParamTranslator
    {
        protected CommonItemParamTranslator()
        {
            this.AddHandler(ProjectParameterNames.ColorIndex, typeof(XmlColorIndexParam));
            this.AddHandler(ProjectParameterNames.Comment, typeof(XmlCommentParam));
            this.AddHandler(ProjectParameterNames.Comment1, typeof(XmlComment1Param));
            this.AddHandler(ProjectParameterNames.Comment2, typeof(XmlComment2Param));
            this.AddHandler(ProjectParameterNames.Comment3, typeof(XmlComment3Param));
            this.AddHandler(ProjectParameterNames.Comment4, typeof(XmlComment4Param));
            this.AddHandler(ProjectParameterNames.Comment5, typeof(XmlComment5Param));
            this.AddHandler(ProjectParameterNames.Comment6, typeof(XmlComment6Param));
            this.AddHandler(ProjectParameterNames.Comment7, typeof(XmlComment7Param));
            this.AddHandler(ProjectParameterNames.Comment8, typeof(XmlComment8Param));
            this.AddHandler(ProjectParameterNames.Comment9, typeof(XmlComment9Param));
            this.AddHandler(
                ProjectParameterNames.EnvelopeParams, typeof(XmlEnvelopeParam),
                XmlEnvelopeParam2Model, Model2XmlEnvelopeParam);
            this.AddHandler(
                ProjectParameterNames.FilePath, typeof(XmlFilePathParam),
                XmlFilePathParam2Model, Model2XmlFilePathParam);
            this.AddHandler(
                ProjectParameterNames.GroupItemRegisterType, typeof(XmlGroupItemRegisterTypeParam),
                XmlGroupItemRegisterTypeParam2Model, Model2XmlGroupItemRegisterTypeParam);
            this.AddHandler(ProjectParameterNames.IsEnabled, typeof(XmlIsEnabledParam));
            this.AddHandler(ProjectParameterNames.Pan, typeof(XmlPanParam));
            this.AddHandler(
                ProjectParameterNames.PanCurve, typeof(XmlPanCurveParam),
                XmlPanCurveParam2Model, Model2XmlPanCurveParam);
            this.AddHandler(
                ProjectParameterNames.PanMode, typeof(XmlPanModeParam),
                XmlPanModeParam2Model, Model2XmlPanModeParam);
            this.AddHandler(ProjectParameterNames.Pitch, typeof(XmlPitchParam));
            this.AddHandler(ProjectParameterNames.SurroundPan, typeof(XmlSurroundPanParam));
            this.AddHandler(
                ProjectParameterNames.TargetItemReference, typeof(XmlTargetItemReferenceParam),
                XmlItemReferenceParam2Model, Model2XmlItemReferenceParam<XmlTargetItemReferenceParam>);
            this.AddHandler(ProjectParameterNames.Volume, typeof(XmlVolumeParam));
            this.AddHandler(
                ProjectParameterNames.WaveEncoding, typeof(XmlWaveEncodingParam),
                XmlWaveEncodingParam2Model, Model2XmlWaveEncodingParam);
            this.AddHandler(ProjectParameterNames.IsResampleEnabled, typeof(XmlIsResampleEnabledParam));
            this.AddHandler(ProjectParameterNames.SampleRate, typeof(XmlSampleRateParam));
            this.AddHandler(ProjectParameterNames.IsDownMixEnabled, typeof(XmlIsDownMixEnabledParam));
            this.AddHandler(
                ProjectParameterNames.BiquadType, typeof(XmlBiquadTypeParam),
                XmlBiquadTypeParam2Model, Model2XmlBiquadTypeParam);
            this.AddHandler(ProjectParameterNames.Sound.SinglePlayType, typeof(XmlSinglePlayTypeParam),
                            XmlSinglePlayTypeParam2Model, Model2XmlSinglePlayTypeParam);
            this.AddHandler(ProjectParameterNames.Sound.SinglePlayEffectiveDuration, typeof(XmlSinglePlayEffectiveDurationParam));
#if false
            this.AddHandler(
                ProjectParameterNames.LoopType, typeof(XmlLoopTypeParam),
                XmlLoopTypeParam2Model, Model2XmlLoopTypeParam);
            this.AddHandler(ProjectParameterNames.LoopStartFrame, typeof(XmlLoopStartFrameParam));
            this.AddHandler(ProjectParameterNames.LoopEndFrame, typeof(XmlLoopEndFrameParam));
#endif

            // サウンドセットアイテム
            this.AddHandler(
                ProjectParameterNames.SoundSetItem.WaveArchiveReference, typeof(XmlWaveArchiveReferenceParam),
                XmlItemReferenceParam2Model, Model2XmlItemReferenceParam<XmlWaveArchiveReferenceParam>);

            // サウンド
            this.AddHandler(
                ProjectParameterNames.Sound.PlayerReference, typeof(XmlPlayerReferenceParam),
                XmlItemReferenceParam2Model, Model2XmlItemReferenceParam<XmlPlayerReferenceParam>);
        }

        public PathResolver PathResolver { get; set; }

        //-----------------------------------------------------------------
        // ユーティリティメソッド
        //-----------------------------------------------------------------

        protected string GetFullPath(string relativePath)
        {
            Assertion.Argument.NotNull(relativePath);
            if (relativePath.Length == 0)
            {
                return string.Empty;
            }

            return (this.PathResolver != null) ?
                this.PathResolver.GetFullPath(relativePath) : relativePath;
        }

        protected string GetRelativePath(string path)
        {
            Assertion.Argument.NotNull(path);

            return (this.PathResolver != null) ?
                this.PathResolver.GetRelativePath(path) : path;
        }

        //-----------------------------------------------------------------
        // InvalidOperation
        //-----------------------------------------------------------------

        protected void InvalidOperation(XmlParameter paramXml, IParameterProvider dest)
        {
            throw new Exception("internal error : invalid operation");
        }

        protected void InvalidOperation(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
        {
            throw new Exception("internal error : invalid operation");
        }

        //-----------------------------------------------------------------
        // Envelope
        //-----------------------------------------------------------------

        private void XmlEnvelopeParam2Model(XmlParameter paramXml, IParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramXml);
            Assertion.Argument.NotNull(dest);

            XmlEnvelopeParam src = paramXml as XmlEnvelopeParam;
            Envelope envelope = new Envelope();

            foreach (XmlParameter xmlParameter in src.Parameters)
            {
                switch (xmlParameter.Name)
                {
                    case XmlParameterNames.Envelope.Attack:
                        envelope.Attack = (xmlParameter as XmlEnvelopeAttackParam).Value;
                        break;

                    case XmlParameterNames.Envelope.Decay:
                        envelope.Decay = (xmlParameter as XmlEnvelopeDecayParam).Value;
                        break;

                    case XmlParameterNames.Envelope.Sustain:
                        envelope.Sustain = (xmlParameter as XmlEnvelopeSustainParam).Value;
                        break;

                    case XmlParameterNames.Envelope.Hold:
                        envelope.Hold = (xmlParameter as XmlEnvelopeHoldParam).Value;
                        break;

                    case XmlParameterNames.Envelope.Release:
                        envelope.Release = (xmlParameter as XmlEnvelopeReleaseParam).Value;
                        break;
                }
            }

            (dest.Parameters[src.Name] as EnvelopeParameterValue).Value = envelope;
        }

        private void Model2XmlEnvelopeParam(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramName);
            Assertion.Argument.NotNull(value);
            Assertion.Argument.True(value is EnvelopeParameterValue);
            Assertion.Argument.NotNull(xmlParamType);
            Assertion.Argument.NotNull(dest);

            EnvelopeParameterValue srcValue = value as EnvelopeParameterValue;
            XmlEnvelopeParam destValue = new XmlEnvelopeParam()
            {
                Parameters = new List<XmlParameter>(),
            };

            destValue.Parameters.Add(
                new XmlEnvelopeAttackParam()
                {
                    Value = srcValue.Attack.Value,
                });

            destValue.Parameters.Add(
                new XmlEnvelopeDecayParam()
                {
                    Value = srcValue.Decay.Value,
                });

            destValue.Parameters.Add(
                new XmlEnvelopeSustainParam()
                {
                    Value = srcValue.Sustain.Value,
                });

            destValue.Parameters.Add(
                new XmlEnvelopeHoldParam()
                {
                    Value = srcValue.Hold.Value,
                });

            destValue.Parameters.Add(
                new XmlEnvelopeReleaseParam()
                {
                    Value = srcValue.Release.Value,
                });

            dest.Parameters.Add(destValue);
        }

        //-----------------------------------------------------------------
        // FilePath
        //-----------------------------------------------------------------

        private void XmlFilePathParam2Model(XmlParameter paramXml, IParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramXml);
            Assertion.Argument.NotNull(dest);

            XmlFilePathParam src = paramXml as XmlFilePathParam;

            this.SetParameterValue(
                dest, src.Name, this.GetFullPath(src.Value));
        }

        private void Model2XmlFilePathParam(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramName);
            Assertion.Argument.NotNull(value);
            Assertion.Argument.True(value is FilePathParameterValue);
            Assertion.Argument.NotNull(xmlParamType);
            Assertion.Argument.NotNull(dest);

            XmlFilePathParam destValue = new XmlFilePathParam();

            if (value.Value as string == string.Empty)
            {
                destValue.Value = value.Value as string;
            }
            else
            {
                destValue.Value = this.GetRelativePath(value.Value as string);
            }

            dest.Parameters.Add(destValue);
        }

        //-----------------------------------------------------------------
        // GroupItemRegisterType
        //-----------------------------------------------------------------

        private void XmlGroupItemRegisterTypeParam2Model(XmlParameter paramXml, IParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramXml);
            Assertion.Argument.NotNull(dest);

            XmlGroupItemRegisterTypeParam src = paramXml as XmlGroupItemRegisterTypeParam;
            GroupItemRegisterType value = GroupItemRegisterTypeEx.Parse(src.Value);

            this.SetParameterValue(dest, src.Name, value);
        }

        private void Model2XmlGroupItemRegisterTypeParam(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramName);
            Assertion.Argument.NotNull(value);
            Assertion.Argument.True(value is GroupItemRegisterTypeParameterValue);
            Assertion.Argument.NotNull(xmlParamType);
            Assertion.Argument.NotNull(dest);

            XmlGroupItemRegisterTypeParam destValue = new XmlGroupItemRegisterTypeParam()
            {
                Value = (value as GroupItemRegisterTypeParameterValue).Value.ToText(),
            };

            dest.Parameters.Add(destValue);
        }

        //-----------------------------------------------------------------
        // ItemReference
        //-----------------------------------------------------------------

        private void XmlItemReferenceParam2Model(XmlParameter paramXml, IParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramXml);
            Assertion.Argument.NotNull(dest);

            XmlItemReferenceParam src = paramXml as XmlItemReferenceParam;

            this.SetParameterValue(dest, src.Name, src.Target);
        }

        private void Model2XmlItemReferenceParam<TXmlParam>(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
            where TXmlParam : XmlItemReferenceParam, new()
        {
            Assertion.Argument.NotNull(paramName);
            Assertion.Argument.NotNull(value);
            Assertion.Argument.NotNull(xmlParamType);
            Assertion.Argument.NotNull(dest);

            XmlItemReferenceParam destValue = new TXmlParam()
            {
                Target = value.Value as string,
            };

            dest.Parameters.Add(destValue);
        }

        //-----------------------------------------------------------------
        // PanCurve
        //-----------------------------------------------------------------

        private void XmlPanCurveParam2Model(XmlParameter paramXml, IParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramXml);
            Assertion.Argument.NotNull(dest);

            XmlPanCurveParam src = paramXml as XmlPanCurveParam;
            PanCurve value = PanCurveEx.Parse(src.Value);

            this.SetParameterValue(dest, src.Name, value);
        }

        private void Model2XmlPanCurveParam(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramName);
            Assertion.Argument.NotNull(value);
            Assertion.Argument.True(value is PanCurveParameterValue);
            Assertion.Argument.NotNull(xmlParamType);
            Assertion.Argument.NotNull(dest);

            XmlPanCurveParam destValue = new XmlPanCurveParam()
            {
                Value = (value as PanCurveParameterValue).Value.ToText(),
            };

            dest.Parameters.Add(destValue);
        }

        //-----------------------------------------------------------------
        // PanMode
        //-----------------------------------------------------------------

        private void XmlPanModeParam2Model(XmlParameter paramXml, IParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramXml);
            Assertion.Argument.NotNull(dest);

            XmlPanModeParam src = paramXml as XmlPanModeParam;
            PanMode value = PanModeEx.Parse(src.Value);

            this.SetParameterValue(dest, src.Name, value);
        }

        private void Model2XmlPanModeParam(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramName);
            Assertion.Argument.NotNull(value);
            Assertion.Argument.True(value is PanModeParameterValue);
            Assertion.Argument.NotNull(xmlParamType);
            Assertion.Argument.NotNull(dest);

            XmlPanModeParam destValue = new XmlPanModeParam()
            {
                Value = (value as PanModeParameterValue).Value.ToText(),
            };

            dest.Parameters.Add(destValue);
        }

        //-----------------------------------------------------------------
        // WaveEncoding
        //-----------------------------------------------------------------

        private void XmlWaveEncodingParam2Model(XmlParameter paramXml, IParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramXml);
            Assertion.Argument.NotNull(dest);

            XmlWaveEncodingParam src = paramXml as XmlWaveEncodingParam;
            WaveEncoding value = WaveEncodingEx.Parse(src.Value);

            this.SetParameterValue(dest, src.Name, value);
        }

        private void Model2XmlWaveEncodingParam(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramName);
            Assertion.Argument.NotNull(value);
            Assertion.Argument.True(value is WaveEncodingParameterValue);
            Assertion.Argument.NotNull(xmlParamType);
            Assertion.Argument.NotNull(dest);

            XmlWaveEncodingParam destValue = new XmlWaveEncodingParam()
            {
                Value = (value as WaveEncodingParameterValue).Value.ToText(),
            };

            dest.Parameters.Add(destValue);
        }

        //-----------------------------------------------------------------
        // BiquadType
        //-----------------------------------------------------------------

        private void XmlBiquadTypeParam2Model(XmlParameter paramXml, IParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramXml);
            Assertion.Argument.NotNull(dest);

            XmlBiquadTypeParam src = paramXml as XmlBiquadTypeParam;
            BiquadType value = BiquadTypeEx.Parse(src.Value);

            this.SetParameterValue(dest, src.Name, value);
        }

        private void Model2XmlBiquadTypeParam(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramName);
            Assertion.Argument.NotNull(value);
            Assertion.Argument.True(value is BiquadTypeParameterValue);
            Assertion.Argument.NotNull(xmlParamType);
            Assertion.Argument.NotNull(dest);

            XmlBiquadTypeParam destValue = new XmlBiquadTypeParam()
            {
                Value = (value as BiquadTypeParameterValue).Value.ToText(),
            };

            dest.Parameters.Add(destValue);
        }

        //-----------------------------------------------------------------
        // SinglePlayType
        //-----------------------------------------------------------------

        private void XmlSinglePlayTypeParam2Model(XmlParameter paramXml, IParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramXml);
            Assertion.Argument.NotNull(dest);

            XmlSinglePlayTypeParam src = paramXml as XmlSinglePlayTypeParam;
            SinglePlayType value = SinglePlayTypeEx.Parse(src.Value);

            this.SetParameterValue(dest, src.Name, value);
        }

        private void Model2XmlSinglePlayTypeParam(
            string paramName, IParameterValue value, Type xmlParamType, IXmlParameterProvider dest)
        {
            Assertion.Argument.NotNull(paramName);
            Assertion.Argument.NotNull(value);
            Assertion.Argument.True(value is SinglePlayTypeParameterValue);
            Assertion.Argument.NotNull(xmlParamType);
            Assertion.Argument.NotNull(dest);

            XmlSinglePlayTypeParam destValue = new XmlSinglePlayTypeParam()
            {
                Value = (value as SinglePlayTypeParameterValue).Value.ToText(),
            };

            dest.Parameters.Add(destValue);
        }
    }
}
