﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary
{
    using System;
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using System.IO;
    using NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary;
    using NintendoWare.ToolDevelopmentKit;
    using NintendoWare.ToolDevelopmentKit.Collections;

    //-----------------------------------------------------------------
    // バイナリ情報
    //-----------------------------------------------------------------

    /// <summary>
    /// 開始位置情報を格納します。
    /// </summary>
    public struct StartPositionInfo
    {
        /// <summary>
        /// データブロックボディ先頭からのオフセットを取得または設定します。
        /// </summary>
        public long OffsetFromDataBlockBody { get; set; }

        /// <summary>
        /// トラックアロケートフラグを取得または設定します。
        /// </summary>
        public uint AllocateTrackFlags { get; set; }
    }

    /// <summary>
    /// ラベル情報を格納します。
    /// </summary>
    public class LabelInfo
    {
        /// <summary>
        /// ラベルを取得または設定します。
        /// </summary>
        public string Label { get; set; }

        /// <summary>
        /// ラベルが参照する絶対位置を取得または設定します。
        /// </summary>
        public long Address { get; set; }

        /// <summary>
        /// ラベルが参照するデータブロックボディ先頭からのオフセットを取得または設定します。
        /// </summary>
        public long OffsetFromDataBlockBody { get; set; }
    }

    /// <summary>
    /// シーケンスサウンドバイナリから情報を読み取るためのクラスです。
    /// </summary>
    public interface ISequenceSoundBinaryReader
    {
        /// <summary>
        /// シーケンスサウンドバイナリを解析します。
        /// </summary>
        /// <param name="reader">シーケンスサウンドバイナリを読み込むリーダを指定します。</param>
        void Parse(BinaryReader reader);

        /// <summary>
        /// ラベル情報リストを取得します。
        /// </summary>
        IKeyedList<string, LabelInfo> LabelInfos { get; }

        /// <summary>
        /// 指定ラベルの再生開始位置情報を取得します。
        /// </summary>
        /// <param name="reader">シーケンスサウンドバイナリを読み込むリーダを指定します。</param>
        /// <param name="label">ラベルを指定します。</param>
        /// <returns>再生開始位置情報を返します。</returns>
        StartPositionInfo GetStartPositionInfo(BinaryReader reader, string label);
    }
}
