﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System.IO;
using YamlDotNet.Serialization;
using YamlDotNet.Serialization.NamingConventions;

namespace NintendoWare.SoundFoundation.FileFormats.NintendoSdk
{
    /// <summary>
    /// アイテムフィルタデータ (yaml) の解析機能を提供します。
    /// </summary>
    public static class ItemFilterParser
    {
        /// <summary>
        /// アイテムフィルタデータ (yaml) を解析します。
        /// </summary>
        /// <param name="stream">アイテムフィルタデータのストリーム。</param>
        /// <returns>解析結果のアイテムフィルタモデル。</returns>
        public static ItemFilterSettings Parse(Stream stream)
        {
            var deserializer = new DeserializerBuilder().WithNamingConvention(new CamelCaseNamingConvention()).Build();

            using (var reader = new StreamReader(stream))
            {
                return deserializer.Deserialize<ItemFilterSettings>(reader);
            }
        }
    }
}
