﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using NintendoWare.SoundFoundation.Core.Resources;

namespace NintendoWare.SoundFoundation.Documents
{
    ///--------------------------------------------------------------------------
    /// <summary>
    /// ドキュメントサービスの特性を取得します。
    /// </summary>
    public interface IDocumentServiceTraits
    {
        string[] SupportedDocumentTypeNames { get; }
        IDocumentFactory GetDocumentFactory(string typeName);

        IDocumentReader GetDocumentReader(IStreamResource resource);
        IDocumentReader GetDocumentReader(string typeName);
        IDocumentWriter GetDocumentWriter(string typeName);

        IDocumentConverter GetDocumentConverter(string inputDocumentTypeName,
                                                 string outputDocuemntTypeName);
        IDocumentConverter[] FindDocumentConverter(string inputDocumentTypeName);
    }
}
