﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Documents
{
    using System;

    public delegate void DocumentEventHandler(object sender, DocumentEventArgs e);

    /// <summary>
    /// ドキュメントイベントデータを格納します。
    /// </summary>
    public class DocumentEventArgs : EventArgs
    {
        private Document document;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="document">ドキュメントを指定します。</param>
        public DocumentEventArgs(Document document)
        {
            this.document = document;
        }

        /// <summary>
        /// ドキュメントを取得します。
        /// </summary>
        public Document Document
        {
            get { return this.document; }
        }
    }
}
