﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Core.Threading
{
    using System;

    /// <summary>
    /// アクションの実行機能を提供します。
    /// </summary>
    public interface IInvoker
    {
        /// <summary>
        /// 指定されたハンドラを非同期で実行します。
        /// </summary>
        /// <param name="handler">ハンドラを指定します。</param>
        /// <returns>結果にアクセスするための IAsyncResult を返します。</returns>
        IAsyncResult BeginInvoke(Action handler);

        /// <summary>
        /// 指定されたハンドラを実行します。
        /// </summary>
        /// <param name="handler">ハンドラを指定します。</param>
        void Invoke(Action handler);
    }
}
