﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;

namespace NintendoWare.SoundFoundation.Core.Resources
{
    public class FileResource : IStreamResource
    {
        private string _FilePath = null;
        private DateTime _LastWriteTime = DateTime.MinValue;

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public FileResource(string filePath)
        {
            _FilePath = filePath;
            ResetLastUpdateDateTime();
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public string FilePath
        {
            get { return _FilePath; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public DateTime LastWriteTime
        {
            get { return _LastWriteTime; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public string Key
        {
            get { return FilePath; }
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public bool CanRead { get; set; }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public bool CanWrite
        {
            get
            {
                if (File.Exists(FilePath) == false)
                {
                    return false;
                }

                FileAttributes attributes = File.GetAttributes(FilePath);
                if ((attributes & FileAttributes.ReadOnly) != 0 ||
                   (attributes & FileAttributes.Directory) != 0)
                {
                    return false;
                }

                return true;
            }
            set { }  //未実装
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public Stream Open(ResourceAccess access, ResourceShare share)
        {
            //未実装
            return null;
        }

        ///--------------------------------
        /// <summary>
        ///
        /// </summary>
        public void ResetLastUpdateDateTime()
        {
            if (null == _FilePath || !File.Exists(_FilePath))
            {
                _LastWriteTime = DateTime.MinValue;
                return;
            }

            _LastWriteTime = File.GetLastWriteTime(_FilePath);
        }
    }
}
