﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Core.IO
{
    using System;
    using System.IO;
    using System.Text;

    public class ReverseEndianBinaryWriter : BinaryWriter
    {
        public ReverseEndianBinaryWriter(Stream stream)
            : base(stream)
        {
        }

        public ReverseEndianBinaryWriter(Stream stream, Encoding encoding)
            : base(stream, encoding)
        {
        }

        public override void Write(short x)
        {
            byte[] bytes = BitConverter.GetBytes(x);
            Array.Reverse(bytes);
            base.Write(bytes);
        }

        public override void Write(int x)
        {
            byte[] bytes = BitConverter.GetBytes(x);
            Array.Reverse(bytes);
            base.Write(bytes);
        }

        public override void Write(long x)
        {
            byte[] bytes = BitConverter.GetBytes(x);
            Array.Reverse(bytes);
            base.Write(bytes);
        }

        public override void Write(ushort x)
        {
            byte[] bytes = BitConverter.GetBytes(x);
            Array.Reverse(bytes);
            base.Write(bytes);
        }

        public override void Write(uint x)
        {
            byte[] bytes = BitConverter.GetBytes(x);
            Array.Reverse(bytes);
            base.Write(bytes);
        }

        public override void Write(ulong x)
        {
            byte[] bytes = BitConverter.GetBytes(x);
            Array.Reverse(bytes);
            base.Write(bytes);
        }

        public override void Write(float x)
        {
            byte[] bytes = BitConverter.GetBytes(x);
            Array.Reverse(bytes);
            base.Write(bytes);
        }
    }
}
