﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Drawing;

namespace NintendoWare.SoundFoundation.Core.Drawing
{
    /// <summary>
    /// ビットマップの拡張機能を提供します。
    /// </summary>
    public static class BitmapEx
    {
        /// <summary>
        /// 新しい透過ビットマップを作成します。
        /// </summary>
        /// <param name="bitmap">元のビットマップ。</param>
        /// <returns>作成された透過ビットマップ</returns>
        public static Bitmap MakeNewTransparent(this Bitmap bitmap)
        {
            Bitmap newBitmap = new Bitmap(bitmap);
            newBitmap.MakeTransparent();
            return newBitmap;
        }

        /// <summary>
        /// 透過色を指定して新しい透過ビットマップを作成します。
        /// </summary>
        /// <param name="bitmap">元のビットマップ。</param>
        /// <param name="transparentColor">透過色。</param>
        /// <returns>作成された透過ビットマップ</returns>
        public static Bitmap MakeNewTransparent(this Bitmap bitmap, Color transparentColor)
        {
            Bitmap newBitmap = new Bitmap(bitmap);
            newBitmap.MakeTransparent(transparentColor);
            return newBitmap;
        }
    }
}
