﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion
{
    using System;

    /// <summary>
    /// サウンドプロジェクトの再コンバートフィルタです。
    /// </summary>
    [Flags]
    public enum SoundProjectReconvertFilter : uint
    {
        StreamSound = 1,
        WaveSoundSet = 2,
        SequenceSound = 4,
        Bank = 8,
        Group = 16,

        None = 0,
        All = uint.MaxValue,
    }

    public static class SoundProjectReconvertFilterExtensions
    {
        public static bool True(this SoundProjectReconvertFilter filter, SoundProjectReconvertFilter flags)
        {
            return (filter & flags) == flags;
        }
    }
}
