﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion
{
    using NintendoWare.ToolDevelopmentKit;

    public abstract class SoundProjectConvertBaseSettings
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="platform">対象プラットフォーム。</param>
        /// <param name="reconvertFilter">再コンバータフィルタ。</param>
        protected SoundProjectConvertBaseSettings(string platform, SoundProjectReconvertFilter reconvertFilter)
        {
            Assertion.Argument.StringNotEmpty(platform);

            this.Platform = platform;
            this.ReconvertFilter = reconvertFilter;
        }

        /// <summary>
        /// 対象プラットフォームを取得します。
        /// </summary>
        public string Platform { get; private set; }

        /// <summary>
        /// 再コンバートフィルタを取得します。
        /// </summary>
        public SoundProjectReconvertFilter ReconvertFilter { get; private set; }
    }
}
