﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion
{
    using System;

    /// <summary>
    ///他の出力に依存した出力アイテムを操作します。
    /// </summary>
    public interface IDependentOutputItem
    {
        /// <summary>
        /// DependencyManagerを取得します。
        /// </summary>
        DependencyManager Owner { get; set; }

        /// <summary>
        /// キーを取得します。
        /// </summary>
        string Key { get; }

        /// <summary>
        /// 出力情報名を取得します。
        /// </summary>
        string Name { get; }

        /// <summary>
        /// 出力ファイルのパスを取得します。
        /// </summary>
        string FilePath { get; }

        /// <summary>
        /// 出力ファイルの絶対パスを取得します。
        /// </summary>
        string AbsoluteFilePath { get; }

        /// <summary>
        /// 最終更新時間を取得します。
        /// </summary>
        DateTime LastUpdatedTime { get; }

        /// <summary>
        /// 出力ファイルを削除します。
        /// </summary>
        void DeleteFile();
    }
}
