﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    using NintendoWare.SoundFoundation.FileFormats.NintendoWareBinary;
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// バイナリファイルを管理します。
    /// </summary>
    public class BinaryFileInfo
    {
        private string soundArchiveSignature = "XSAR";
        private string streamSoundSignature = "XSTM";
        private string streamSoundPrefetchSignature = "XSTP";
        private string waveSoundSignature = "XWSD";
        private string waveSound2Signature = "BAWSD   ";
        private string sequenceSoundSignature = "XSEQ";
        private string bankSignature = "XBNK";
        private string waveSignature = "XWAV";
        private string waveArchiveSignature = "XWAR";
        private string groupSignature = "XGRP";

        private BinaryVersion soundArchiveVersion = new BinaryVersion();
        private BinaryVersion streamSoundVersion = new BinaryVersion();
        private BinaryVersion streamSoundPrefetchVersion = new BinaryVersion();
        private BinaryVersion waveSoundVersion = new BinaryVersion();
        private BinaryVersion waveSound2Version = new BinaryVersion();
        private BinaryVersion sequenceSoundVersion = new BinaryVersion();
        private BinaryVersion bankVersion = new BinaryVersion();
        private BinaryVersion waveVersion = new BinaryVersion();
        private BinaryVersion waveArchiveVersion = new BinaryVersion();
        private BinaryVersion groupVersion = new BinaryVersion();

        //-----------------------------------------------------------------

        public string SoundArchiveSignature
        {
            get { return this.soundArchiveSignature; }
            set
            {
                this.ValidateSignature(value);
                this.soundArchiveSignature = value;
            }
        }

        public string StreamSoundSignature
        {
            get { return this.streamSoundSignature; }
            set
            {
                this.ValidateSignature(value);
                this.streamSoundSignature = value;
            }
        }

        public string StreamSoundPrefetchSignature
        {
            get { return this.streamSoundPrefetchSignature; }
            set
            {
                this.ValidateSignature(value);
                this.streamSoundPrefetchSignature = value;
            }
        }

        public string WaveSoundSignature
        {
            get { return this.waveSoundSignature; }
            set
            {
                this.ValidateSignature(value);
                this.waveSoundSignature = value;
            }
        }

        public string WaveSound2Signature
        {
            get { return this.waveSound2Signature; }
            set
            {
                // ファイル出力時にシグネチャを検証するので、ここでは検証しない
                this.waveSound2Signature = value;
            }
        }

        public string SequenceSoundSignature
        {
            get { return this.sequenceSoundSignature; }
            set
            {
                this.ValidateSignature(value);
                this.sequenceSoundSignature = value;
            }
        }

        public string WaveSignature
        {
            get { return this.waveSignature; }
            set
            {
                this.ValidateSignature(value);
                this.waveSignature = value;
            }
        }

        public string WaveArchiveSignature
        {
            get { return this.waveArchiveSignature; }
            set
            {
                this.ValidateSignature(value);
                this.waveArchiveSignature = value;
            }
        }

        public string BankSignature
        {
            get { return this.bankSignature; }
            set
            {
                this.ValidateSignature(value);
                this.bankSignature = value;
            }
        }

        public string GroupSignature
        {
            get { return this.groupSignature; }
            set
            {
                this.ValidateSignature(value);
                this.groupSignature = value;
            }
        }

        public BinaryVersion SoundArchiveVersion
        {
            get { return this.soundArchiveVersion; }
            set { this.soundArchiveVersion = value; }
        }

        public BinaryVersion StreamSoundVersion
        {
            get { return this.streamSoundVersion; }
            set { this.streamSoundVersion = value; }
        }

        public BinaryVersion StreamSoundPrefetchVersion
        {
            get { return this.streamSoundPrefetchVersion; }
            set { this.streamSoundPrefetchVersion = value; }
        }

        public BinaryVersion WaveSoundVersion
        {
            get { return this.waveSoundVersion; }
            set { this.waveSoundVersion = value; }
        }

        public BinaryVersion WaveSound2Version
        {
            get { return this.waveSound2Version; }
            set { this.waveSound2Version = value; }
        }

        public BinaryVersion SequenceSoundVersion
        {
            get { return this.sequenceSoundVersion; }
            set { this.sequenceSoundVersion = value; }
        }

        public BinaryVersion WaveVersion
        {
            get { return this.waveVersion; }
            set { this.waveVersion = value; }
        }

        public BinaryVersion WaveArchiveVersion
        {
            get { return this.waveArchiveVersion; }
            set { this.waveArchiveVersion = value; }
        }

        public BinaryVersion BankVersion
        {
            get { return this.bankVersion; }
            set { this.bankVersion = value; }
        }

        public BinaryVersion GroupVersion
        {
            get { return this.groupVersion; }
            set { this.groupVersion = value; }
        }

        //-----------------------------------------------------------------

        private void ValidateSignature(string value)
        {
            Ensure.Argument.NotNull(value);
            Ensure.Argument.True(value.Length == 4);
        }
    }
}
