﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using NintendoWare.SoundFoundation.FileFormats.NintendoSdk;

namespace NintendoWare.SoundFoundation.Conversion.NintendoWareBinary
{
    /// <summary>
    /// サウンドプロジェクトコンバート設定を格納します。
    /// </summary>
    public class SoundProjectConversionSettings
    {
        public SoundProjectConversionSettings()
        {
            this.ParallelConversionCountMax = 1;
            this.IsPreConvertCommandsIgnored = false;
            this.IsPostConvertCommandsIgnored = false;
            this.ExcludeStringTable = false;
            this.DoWarnUnReferencedItems = false;
            this.IsConvertParts = true;
        }

        /// <summary>
        /// 並列コンバートの最大数を取得または設定します。
        /// </summary>
        public uint ParallelConversionCountMax { get; set; }

        /// <summary>
        /// コンバート前コマンドを無効化するかどうかを取得または設定します。
        /// </summary>
        public bool IsPreConvertCommandsIgnored { get; set; }

        /// <summary>
        /// コンバート後コマンドを無効化するかどうかを取得または設定します。
        /// </summary>
        public bool IsPostConvertCommandsIgnored { get; set; }

        /// <summary>
        /// 文字列テーブルを出力するかどうかを取得または設定します。
        /// </summary>
        public bool ExcludeStringTable { get; set; }

        /// <summary>
        /// 未使用のアイテムを警告するかどうかを取得または設定します。
        /// </summary>
        public bool DoWarnUnReferencedItems { get; set; }

        /// <summary>
        /// 部分コンバートかどうかを取得または設定します。
        /// </summary>
        public bool IsConvertParts { get; set; }

        /// <summary>
        /// アイテムの除外フィルタ設定を取得または設定します。
        /// </summary>
        public ItemFilterSettings ExcludeItemFilterSettings { get; set; }

        /// <summary>
        /// アイテムの包含フィルタ設定を取得または設定します。
        /// </summary>
        public ItemFilterSettings IncludeItemFilterSettings { get; set; }
    }
}
