﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.Generic;
using System.Linq;
using NintendoWare.SoundFoundation.Core.Collections;

namespace NintendoWare.SoundFoundation.Commands
{
    /// <summary>
    /// コマンドに関連付けられたパラメータ名と値のディクショナリです。
    /// </summary>
    public class CommandParameterDictionary :
        Dictionary<string, string>,
        IReadOnlyCommandParameterDictionary
    {
        /// <summary>
        /// 値の一覧を取得します。
        /// </summary>
        IEnumerable<string> IReadOnlyDictionary<string, string>.Values
        {
            get { return Values; }
        }

        /// <summary>
        /// 指定パラメータを取得できるかどうか調べます。
        /// </summary>
        /// <param name="command">対象コマンド。</param>
        /// <param name="parameterName">パラメータ名。</param>
        /// <returns>取得できる場合は true、できない場合は false。</returns>
        bool IQueryCommandParameter.ContainsParameter(string parameterName)
        {
            return ContainsKey(parameterName);
        }

        /// <summary>
        /// 指定パラメータを取得します。
        /// </summary>
        /// <param name="command">対象コマンド。</param>
        /// <param name="parameterName">パラメータ名。</param>
        /// <returns>コマンドのパラメータ。</returns>
        object IQueryCommandParameter.GetParameter(string parameterName)
        {
            return this[parameterName];
        }
    }
}
