﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System.Collections.ObjectModel;

namespace NintendoWare.SoundFoundation.Commands
{
    /// <summary>
    /// コマンドのコレクションを管理します。
    /// </summary>
    public class CommandCollection : KeyedCollection<string, Command>, ICommandCollection
    {
        /// <summary>
        /// アイテムからキーを取得します。
        /// </summary>
        /// <param name="item">アイテム。</param>
        /// <returns>アイテムのキー。</returns>
        protected override string GetKeyForItem(Command item)
        {
            return item.Uri;
        }
    }
}
