﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Codecs
{
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// サンプルを溜め込み取得します。
    /// </summary>
    public class SampleGrabber : SampleSpooler
    {
        private byte[] spooledBuffer = null;

        /// <summary>
        /// サンプルのバイト列を取得します。
        /// </summary>
        public byte[] Samples
        {
            get { return this.spooledBuffer; }
        }

        /// <summary>
        /// パケットを処理します。
        /// </summary>
        /// <param name="input">入力接続ポイントを指定します。</param>
        /// <param name="packet">パケットを指定します。</param>
        protected override void Process(InputConnectionPoint input, Packet packet)
        {
            var spooledPacket = this.Spool(packet);

            if (spooledPacket.Length > 0)
            {
                // １パケットにまとめているので、２パケット以上が取得できることはない。
                Ensure.Operation.True(spooledPacket.Length == 1);
                Ensure.Operation.ObjectNull(this.spooledBuffer);
                this.spooledBuffer = spooledPacket[0].Samples;
            }
        }
    }
}
