﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.SoundFoundation.Codecs
{
    using NintendoWare.ToolDevelopmentKit;

    /// <summary>
    /// パケット送信をサポートする接続ポイントです。
    /// </summary>
    public class OutputConnectionPoint : ConnectionPoint<InputConnectionPoint>
    {
        private int sentLength = 0;

        public OutputConnectionPoint(WaveStreamInformation streamInformation)
        {
            this.StreamInformation = streamInformation;
        }

        /// <summary>
        /// 送信したパケットの合計サイズを取得します。
        /// </summary>
        public int SentLength
        {
            get { return this.sentLength; }
        }

        /// <summary>
        /// パケットを送信します。
        /// </summary>
        /// <param name="packet">送信するパケットを指定します。</param>
        public void Send(Packet packet)
        {
            Ensure.Argument.NotNull(packet);

            this.sentLength += packet.Samples.Length;
            this.SendInternal(packet);
        }
    }
}
