﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Binarization
{
    using System;

    internal class DomObjectAligner : IDomObjectProcessor
    {
        private uint alignment = 0;

        public DomObjectAligner(uint alignment)
        {
            if (int.MaxValue < alignment)
            {
                throw new ArgumentOutOfRangeException("alignment");
            }

            this.alignment = alignment;
        }

        public void Run(DomObject obj, IDomContext context)
        {
            DomWriterContext writerContext = context as DomWriterContext;
            if (null == writerContext)
            {
                throw new ArgumentException("objectProcessor must be DomWriterContext.");
            }

            if (0 == this.alignment) { return; }

            writerContext.Writer.Align((int)this.alignment);
        }
    }
}
