﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Binarization
{
    using System;

    [AttributeUsage(
        AttributeTargets.Class | AttributeTargets.Struct |
        AttributeTargets.Property,
        AllowMultiple = true,
        Inherited = false)]
    public abstract class DomProcessorAttribute : Attribute
    {
        private DomAttributeTarget target = DomAttributeTarget.FieldValues;
        private Type processorType;
        private IDomObjectProcessor customProcessor;

        private Type customProcessorType;

        public DomProcessorAttribute(Type processorType, Type customProcessorType)
            : this(processorType)
        {
            if (null == customProcessorType)
            {
                throw new ArgumentNullException("customProcessorType");
            }

            if (customProcessorType.IsAbstract)
            {
                throw new ArgumentException("customProcessorType must not be abstract.");
            }

            if (customProcessorType.GetInterface(typeof(IDomObjectProcessor).Name)
                    != typeof(IDomObjectProcessor))
            {
                throw new ArgumentException("postProcessorType must implement IDomObjectProcessor.");
            }

            this.customProcessorType = customProcessorType;
        }

        protected DomProcessorAttribute(Type processorType)
        {
            if (null == processorType) { throw new ArgumentNullException("processorType"); }

            if (processorType.IsAbstract)
            {
                throw new ArgumentException("processorType must not be abstract.");
            }

            if (processorType.GetInterface(typeof(IDomObjectProcessor).Name) != typeof(IDomObjectProcessor))
            {
                throw new ArgumentException("processorType must implement IDomObjectProcessor.");
            }

            this.processorType = processorType;
        }

        /// <summary>
        /// 属性を適用する対象を取得または設定します。
        /// </summary>
        public DomAttributeTarget Target
        {
            get { return this.target; }
            set { this.target = value; }
        }

        public Type ProcessorType
        {
            get { return this.processorType; }
        }

        public IDomObjectProcessor CustomProcessor
        {
            get
            {
                if (null == this.customProcessor)
                {
                    this.customProcessor = CreateCustomProcessor();
                }
                return this.customProcessor;
            }
        }

        protected virtual IDomObjectProcessor CreateCustomProcessor()
        {
            return Activator.CreateInstance(this.customProcessorType) as IDomObjectProcessor;
        }
    }
}
