﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Binarization
{
    using System;
    using ToolDevelopmentKit;

    [AttributeUsage(AttributeTargets.Property, Inherited = false)]
    public class EnumeratedFieldAttribute : DomFieldBaseAttribute
    {
        private Type fieldNameProviderType;

        public EnumeratedFieldAttribute()
        {
        }

        public EnumeratedFieldAttribute(Type fieldNameProviderType)
        {
            Assertion.Argument.NotNull(fieldNameProviderType);

            if (fieldNameProviderType.IsAbstract)
            {
                throw new ArgumentException("fieldNameProviderType must not be abstract.");
            }

            if (fieldNameProviderType.GetInterface(typeof(IDomElementFieldNameProvider).Name)
                    != typeof(IDomElementFieldNameProvider))
            {
                throw new ArgumentException("fieldNameProviderType must implement IFieldNameProvider.");
            }

            this.fieldNameProviderType = fieldNameProviderType;
        }

        protected override IDomElementFieldNameProvider CreateFieldNameProvider()
        {
            IDomElementFieldNameProvider nameProvider;

            if (this.fieldNameProviderType == null)
            {
                nameProvider = new ConstDomElementFieldNameProvider();
            }
            else
            {
                nameProvider = Activator.CreateInstance(this.fieldNameProviderType)
                               as IDomElementFieldNameProvider;
            }

            return nameProvider;
        }
    }
}
