﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
namespace NintendoWare.SoundFoundation.Binarization
{
    using System.Collections.Generic;
    using System.Collections.ObjectModel;
    using Core;

    /// <summary>
    /// DomObject のコレクションです。
    /// </summary>
    public class DomObjectCollection :
        TreeObjectCollectionBase<DomObject>,
        ICollection<DomObject>
    {
        public readonly static DomObjectCollection Empty = new DomObjectCollection();

        private IList<DomObject> innerCollection;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        /// <param name="owner">コレクションの所有者。</param>
        public DomObjectCollection(DomObject owner)
            : base(owner)
        {
            this.innerCollection = new List<DomObject>();
        }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        private DomObjectCollection()
            : base(null)
        {
            this.innerCollection = new DomObject[0];
        }

        /// <summary>
        /// 内部コレクションを取得します。
        /// </summary>
        protected override IList<DomObject> InnerCollection
        {
            get { return this.innerCollection; }
        }
    }

}
