﻿namespace Opal.ViewModels
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.Services;

    /// <summary>
    /// アクティブなドキュメントが変更された時のイベント引数クラスです。
    /// </summary>
    public sealed class ActiveDocumentChangedEventArgs : EventArgs
    {
        private readonly WeakReference<IDocument> weakDocument;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="document">アクティブ対象のドキュメントです。</param>
        internal ActiveDocumentChangedEventArgs(IDocument document)
        {
            this.weakDocument = new WeakReference<IDocument>(document);
        }

        /// <summary>
        /// 弱参照ドキュメントを取得します。
        /// </summary>
        public WeakReference<IDocument> WeakDocument
        {
            get
            {
                return this.weakDocument;
            }
        }
    }
}
