﻿namespace Opal.ViewModels
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.ViewModels;

    /// <summary>
    /// アクティブな状態が変更された時のイベント引数クラスです。
    /// </summary>
    public class ActiveChangedEventArgs : EventArgs
    {
        private bool isActive;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="active">アクティブ状態です。</param>
        public ActiveChangedEventArgs(bool active)
        {
            this.isActive = active;
        }

        /// <summary>
        /// アクティブ状態を取得します。
        /// </summary>
        public bool IsActive
        {
            get
            {
                return this.isActive;
            }
        }
    }
}
