﻿namespace Opal.Threading
{
    using System;
    using System.Collections.Generic;
    using System.Diagnostics;
    using System.IO;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using System.Xml;
    using System.Xml.Serialization;
    using Opal.ComponentModel;

    /// <summary>
    /// ジョブクラスです。
    /// </summary>
    public abstract class Job : DisposableObservableObject
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="name">ジョブの名前です。</param>
        public Job(string name)
        {
            Debug.Assert(!string.IsNullOrEmpty(name));
            this.Name = name;
        }

        /// <summary>
        /// 名前です。
        /// </summary>
        public string Name { get; protected set; }

        /// <summary>
        /// ジョブを停止します。
        /// </summary>
        public virtual void Stop()
        {
        }
    }
}
