﻿namespace Opal.Storages
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.ComponentModel;
    using Opal.Services;
    using Opal.Utilities;
    using Opal.ViewModels;

    /// <summary>
    /// ストレージクラスです。
    /// </summary>
    public abstract class Storage : DisposableObservableObject
    {
        private EventHandler<StorageChangedEventArgs> storageChanged;

        /// <summary>
        /// ストレージの状態が変更された時に実行されるイベントです。
        /// </summary>
        internal event EventHandler<StorageChangedEventArgs> StorageChanged
        {
            add
            {
                this.storageChanged += value.MakeWeakEventHandler(eventHandler => this.storageChanged -= eventHandler);
            }

            remove
            {
            }
        }

        /// <summary>
        /// ストレージ変更のイベントを発行します。
        /// </summary>
        /// <param name="value">設定する変更された値です。渡すものはアプリ側の任意の型になります。</param>
        public void RaiseStorageChanged(object value)
        {
            if (this.storageChanged != null)
            {
                this.storageChanged(this, new StorageChangedEventArgs(this, value));
            }
        }

        /// <summary>
        /// データを格納するストレージの状態をクリアします。
        /// </summary>
        public abstract void Clear();

        /// <summary>
        /// アクティブなドキュメントが変更された時に実行されます。
        /// </summary>
        /// <param name="sender">送信元のオブジェクトです。</param>
        /// <param name="e">イベント引数です。</param>
        internal void CallActiveDocumentChanged(object sender, ActiveDocumentChangedEventArgs e)
        {
            this.OnActiveDocumentChanged(e);
        }

        /// <summary>
        /// アクティブなドキュメントが変更された時に実行される処理です。
        /// </summary>
        /// <param name="e">イベント引数です。</param>
        protected virtual void OnActiveDocumentChanged(ActiveDocumentChangedEventArgs e)
        {
        }
    }
}
