﻿namespace Opal.Storages
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;
    using Opal.Utilities;

    /// <summary>
    /// ストレージ管理インターフェースです。
    /// </summary>
    public interface IStorageManager : IAnyManager
    {
        /// <summary>
        /// ストレージを取得します。
        /// </summary>
        /// <typeparam name="TStorage">ストレージのテンプレートの型です。</typeparam>
        /// <returns>指定したグループに存在するストレージのインスタンスを返します。</returns>
        WeakReference<TStorage> GetStorage<TStorage>() where TStorage : Storage;

        /// <summary>
        /// ストレージを取得を試行します。
        /// </summary>
        /// <typeparam name="TStorage">ストレージのテンプレートの型です。</typeparam>
        /// <param name="storage">取得成功ならば、ストレージのインスタンスを格納します。存在しない場合は、null を格納します。</param>
        /// <returns>取得成功の場合は、true を失敗の場合は、false を返します。</returns>
        bool TryGetStorage<TStorage>(out WeakReference<TStorage> storage) where TStorage : Storage;

        /// <summary>
        /// ストレージを所有しているか判定します。
        /// </summary>
        /// <typeparam name="TStorage">ストレージのテンプレートの型です。</typeparam>
        /// <returns>所有している場合は、true 所有していない場合は、false を返します。</returns>
        bool HasStorage<TStorage>() where TStorage : Storage;

        /// <summary>
        /// ストレージを追加します。
        /// </summary>
        /// <typeparam name="TStorage">ストレージのテンプレートの型です。</typeparam>
        /// <param name="storage">追加するストレージです。</param>
        void AddStorage<TStorage>(TStorage storage) where TStorage : Storage;

        /// <summary>
        /// ストレージを削除します。
        /// </summary>
        /// <typeparam name="TStorage">ストレージのテンプレートの型です。</typeparam>
        void RemoveStorage<TStorage>() where TStorage : Storage;
    }
}
