﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using nw.g3d.nw4f_3dif;
using Opal.Security.Cryptography;
using Nintendo.ToolFoundation.Collections;
using Nintendo.ToolFoundation.Contracts;
using Nintendo.G3dTool.Entities.Internal;

namespace Nintendo.G3dTool.Entities
{
    public class Wrap : ObservableEntity<wrapType>, IDeepCopyable<Wrap>, IDeepCopyFrom<Wrap>
    {
        private wrap_uvwType @u = wrap_uvwType.clamp;
        private wrap_uvwType @v = wrap_uvwType.clamp;
        private wrap_uvwType @w = wrap_uvwType.clamp;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public Wrap()
        {
        }

        /// <summary>
        /// コピーコンストラクタです。
        /// </summary>
        /// <param name="source">設定するデータです。</param>
        public Wrap(Wrap source)
            : this()
        {
            this.DeepCopyFrom(source);
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="source">設定するデータです。</param>
        public Wrap(wrapType source)
        {
            this.@u = source.@u;
            this.@v = source.@v;
            this.@w = source.@w;
        }

        public wrap_uvwType U
        {
            get
            {
                return this.@u;
            }

            set
            {
                if (this.@u == value)
                {
                    return;
                }

                this.SetProperty(ref this.@u, value, () => this.CalcCRC());
            }
        }

        public wrap_uvwType V
        {
            get
            {
                return this.@v;
            }

            set
            {
                if (this.@v == value)
                {
                    return;
                }

                this.SetProperty(ref this.@v, value, () => this.CalcCRC());
            }
        }

        public wrap_uvwType W
        {
            get
            {
                return this.@w;
            }

            set
            {
                if (this.@w == value)
                {
                    return;
                }

                this.SetProperty(ref this.@w, value, () => this.CalcCRC());
            }
        }

        /// <summary>
        /// 出力データを作成します。
        /// </summary>
        /// <returns>出力データのインスタンスを返します。</returns>
        public override wrapType CreateSerializableData()
        {
            var writeData = new wrapType();
            writeData.@u = this.U;
            writeData.@v = this.V;
            writeData.@w = this.W;
            return writeData;
        }

        /// <summary>
        /// 現在のインスタンスをディープコピーで複製した新規インスタンスを返します。
        /// </summary>
        Wrap IDeepCopyable<Wrap>.DeepCopy()
        {
            return new Wrap(this);
        }

        /// <summary>
        /// 入力ファイルからディープコピーします。
        /// </summary>
        /// <param name="source">コピー元となる入力ファイルです。</param>
        public void DeepCopyFrom(Wrap source)
        {
            this.@u = source.@u;
            this.@v = source.@v;
            this.@w = source.@w;
        }

        /// <summary>
        /// エンティティの CRC を作成します。（内部処理用）
        /// </summary>
        /// <returns>CRC の値を返します。</returns>
        protected override uint CreateCRCInternal()
        {
            CRC32 crc = new CRC32();
            List<byte> buffers = new List<byte>();
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.U)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.V)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.W)));
            return crc.ComputeHashUInt32(buffers.ToArray());
        }
    }
}
