﻿using Nintendo.G3dTool.Entities.Internal;
using Nintendo.ToolFoundation.Contracts;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Text;
using System.Threading.Tasks;

namespace Nintendo.G3dTool.Entities
{
    /// <summary>
    /// 最小限の実装のみを派生クラスに要求するツールデータオブジェクトの抽象クラスです。
    /// </summary>
    public abstract class ToolDataObject : Opal.ComponentModel.ObservableObject, IToolDataObject
    {
        public virtual uint CalculateCrc()
        {
            // ダーティフラグ計算を利用する場合だけ派生クラスで実装する
            throw new NotImplementedException();
        }

        public virtual IToolDataObject DeepCopy()
        {
            // 標準実装はリフレクションで書き込み可能なプロパティをすべてコピー
            return CopyUtility.DeepCopy(this) as IToolDataObject;
        }

        public virtual object CreateSerializableData()
        {
            // 自身をシリアライズ可能データに変換する場合だけ派生クラスで実装する
            return this;
        }
    }
}
