﻿namespace Nintendo.G3dTool.Entities
{
    using Nintendo.G3dTool.Entities.Internal;
    using Nintendo.ToolFoundation.Collections;
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// ルートのデータ操作用インターフェースです。
    /// </summary>
    public interface IRootEntity : IEntity, IDeepCopyable<IRootEntity>, IDeepCopyFrom<IRootEntity>, IChildEntity
    {
        bool IsStreamSerializationEnabled { get; set; }

        ObservableList<Stream> Streams { get; }

        /// <summary>
        /// ファイル内の参照解決を行います。
        /// </summary>
        void ResolveInternalReferences();
    }
}
