﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace Nintendo.G3dTool.Entities
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Linq;
    using System.Text;
    using System.Threading.Tasks;

    /// <summary>
    /// データ操作用のインターフェースです。
    /// </summary>
    public interface IEntity : INotifyPropertyChanged
    {
        /// <summary>
        /// エンティティの値が変更されているかどうかを取得します。
        /// </summary>
        bool IsDirty { get; }

        /// <summary>
        /// エンティティがもつ値が変更された場合に自動でCRCを計算するフラグを取得設定します。
        /// </summary>
        bool AutoCalc { get; set; }

        /// <summary>
        /// ハッシュ値を取得します。
        /// </summary>
        uint HashValue { get; }

        /// <summary>
        /// エンティティの状態をリセットします。
        /// </summary>
        void Reset();

        /// <summary>
        /// エンティティの状態を更新します。
        /// </summary>
        void Refresh();

        /// <summary>
        /// 出力データを作成します。
        /// </summary>
        /// <returns>出力データのインスタンスを返します。</returns>
        object CreateSerializableData();
    }
}
