﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;
using nw.g3d.nw4f_3dif;
using Opal.Security.Cryptography;
using Nintendo.ToolFoundation.Collections;
using Nintendo.ToolFoundation.Contracts;
using Nintendo.G3dTool.Entities.Internal;

namespace Nintendo.G3dTool.Entities
{
    public class BoneAnim : ObservableEntity<bone_animType>, IChildEntity, IDeepCopyable<BoneAnim>, IDeepCopyFrom<BoneAnim>
    {
        private string @name = string.Empty;
        private readonly ObservableDictionary<bone_anim_target_targetType, BoneAnimTarget> @boneAnimTargets = new ObservableDictionary<bone_anim_target_targetType, BoneAnimTarget>();
        private readonly ObservableList<UserData> @userDatas = new ObservableList<UserData>();
        private string @boneName = "undefined";
        private string @parentName = string.Empty;
        private bool @rigidBody = true;
        private bool @scaleCompensate = true;
        private bool @binarizeScale;
        private bool @binarizeRotate;
        private bool @binarizeTranslate;
        private bool @compressEnable = true;
        private SkeletalAnim parent = null;
        private int @smoothSkinningMatrixIndex = -1;
        private int @rigidSkinningMatrixIndex = -1;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public BoneAnim()
        {
            this.@boneAnimTargets.CollectionChanged += OnDictionaryChanged<bone_anim_target_targetType, BoneAnimTarget>;
            this.@boneAnimTargets.Add(bone_anim_target_targetType.scale_x, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.scale_x
            });
            this.@boneAnimTargets.Add(bone_anim_target_targetType.scale_y, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.scale_y
            });
            this.@boneAnimTargets.Add(bone_anim_target_targetType.scale_z, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.scale_z
            });
            this.@boneAnimTargets.Add(bone_anim_target_targetType.rotate_x, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.rotate_x
            });
            this.@boneAnimTargets.Add(bone_anim_target_targetType.rotate_y, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.rotate_y
            });
            this.@boneAnimTargets.Add(bone_anim_target_targetType.rotate_z, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.rotate_z
            });
            this.@boneAnimTargets.Add(bone_anim_target_targetType.rotate_w, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.rotate_w
            });
            this.@boneAnimTargets.Add(bone_anim_target_targetType.translate_x, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.translate_x
            });
            this.@boneAnimTargets.Add(bone_anim_target_targetType.translate_y, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.translate_y
            });
            this.@boneAnimTargets.Add(bone_anim_target_targetType.translate_z, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.translate_z
            });
            this.@userDatas.CollectionChanged += OnCollectionChanged<UserData>;
        }

        /// <summary>
        /// コピーコンストラクタです。
        /// </summary>
        /// <param name="source">設定するデータです。</param>
        public BoneAnim(BoneAnim source)
            : this()
        {
            this.DeepCopyFrom(source);
        }

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="source">設定するデータです。</param>
        public BoneAnim(bone_animType source)
        {
            this.@boneAnimTargets.CollectionChanged += OnDictionaryChanged<bone_anim_target_targetType, BoneAnimTarget>;
            this.@boneAnimTargets.Add(bone_anim_target_targetType.scale_x, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.scale_x
            });
            this.@boneAnimTargets.Add(bone_anim_target_targetType.scale_y, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.scale_y
            });
            this.@boneAnimTargets.Add(bone_anim_target_targetType.scale_z, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.scale_z
            });
            this.@boneAnimTargets.Add(bone_anim_target_targetType.rotate_x, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.rotate_x
            });
            this.@boneAnimTargets.Add(bone_anim_target_targetType.rotate_y, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.rotate_y
            });
            this.@boneAnimTargets.Add(bone_anim_target_targetType.rotate_z, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.rotate_z
            });
            this.@boneAnimTargets.Add(bone_anim_target_targetType.rotate_w, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.rotate_w
            });
            this.@boneAnimTargets.Add(bone_anim_target_targetType.translate_x, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.translate_x
            });
            this.@boneAnimTargets.Add(bone_anim_target_targetType.translate_y, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.translate_y
            });
            this.@boneAnimTargets.Add(bone_anim_target_targetType.translate_z, new BoneAnimTarget()
            {
                Target = bone_anim_target_targetType.translate_z
            });
            this.@userDatas.CollectionChanged += OnCollectionChanged<UserData>;
            this.@name = source.@name;
            if (source.bone_anim_target != null)
            {
                foreach (var elem in source.bone_anim_target)
                {
                    this.@boneAnimTargets[elem.target] = new BoneAnimTarget(elem);
                }
            }
            if (source.@user_data_array != null)
            {
                this.@userDatas.Clear();
                foreach (var elem in source.@user_data_array.Items)
                {
                    this.@userDatas.Add(DataModelConverter.Convert(elem));
                }
            }
            this.@boneName = source.@bone_name;
            this.@parentName = source.@parent_name;
            this.@rigidBody = source.@rigid_body;
            this.@scaleCompensate = source.@scale_compensate;
            this.@binarizeScale = source.@binarize_scale;
            this.@binarizeRotate = source.@binarize_rotate;
            this.@binarizeTranslate = source.@binarize_translate;
            this.@compressEnable = source.@compress_enable;
            this.@smoothSkinningMatrixIndex = source.matrix_index[0];
            this.@rigidSkinningMatrixIndex = source.matrix_index[1];
        }

        public string Name
        {
            get
            {
                return this.@name;
            }

            set
            {
                if (this.@name == value)
                {
                    return;
                }

                Ensure.Argument.NotNull(value);
                this.SetProperty(ref this.@name, value, () => this.CalcCRC());
            }
        }

        public IReadOnlyDictionary<bone_anim_target_targetType, BoneAnimTarget> BoneAnimTargets
        {
            get
            {
                return this.@boneAnimTargets as IReadOnlyDictionary<bone_anim_target_targetType, BoneAnimTarget>;
            }
        }

        public ObservableList<UserData> UserDatas
        {
            get
            {
                return this.@userDatas;
            }
        }

        public string BoneName
        {
            get
            {
                return this.@boneName;
            }

            set
            {
                if (this.@boneName == value)
                {
                    return;
                }

                Ensure.Argument.NotNull(value);
                this.SetProperty(ref this.@boneName, value, () => this.CalcCRC());
            }
        }

        public string ParentName
        {
            get
            {
                return this.@parentName;
            }

            set
            {
                if (this.@parentName == value)
                {
                    return;
                }

                Ensure.Argument.NotNull(value);
                this.SetProperty(ref this.@parentName, value, () => this.CalcCRC());
            }
        }

        public bool RigidBody
        {
            get
            {
                return this.@rigidBody;
            }

            set
            {
                if (this.@rigidBody == value)
                {
                    return;
                }

                this.SetProperty(ref this.@rigidBody, value, () => this.CalcCRC());
            }
        }

        public bool ScaleCompensate
        {
            get
            {
                return this.@scaleCompensate;
            }

            set
            {
                if (this.@scaleCompensate == value)
                {
                    return;
                }

                this.SetProperty(ref this.@scaleCompensate, value, () => this.CalcCRC());
            }
        }

        public bool BinarizeScale
        {
            get
            {
                return this.@binarizeScale;
            }

            set
            {
                if (this.@binarizeScale == value)
                {
                    return;
                }

                this.SetProperty(ref this.@binarizeScale, value, () => this.CalcCRC());
            }
        }

        public bool BinarizeRotate
        {
            get
            {
                return this.@binarizeRotate;
            }

            set
            {
                if (this.@binarizeRotate == value)
                {
                    return;
                }

                this.SetProperty(ref this.@binarizeRotate, value, () => this.CalcCRC());
            }
        }

        public bool BinarizeTranslate
        {
            get
            {
                return this.@binarizeTranslate;
            }

            set
            {
                if (this.@binarizeTranslate == value)
                {
                    return;
                }

                this.SetProperty(ref this.@binarizeTranslate, value, () => this.CalcCRC());
            }
        }

        public bool CompressEnable
        {
            get
            {
                return this.@compressEnable;
            }

            set
            {
                if (this.@compressEnable == value)
                {
                    return;
                }

                this.SetProperty(ref this.@compressEnable, value, () => this.CalcCRC());
            }
        }

        IEntity IChildEntity.Parent
        {
            get
            {
                return this.parent as IEntity;
            }

            set
            {
                if (this.parent == value)
                {
                    return;
                }

                Ensure.Argument.True(value != null ? value is SkeletalAnim : true);
                this.SetProperty(ref this.parent, value as SkeletalAnim, () => this.CalcCRC());
            }
        }

        public SkeletalAnim Parent
        {
            get
            {
                return this.parent;
            }
        }

        Type IChildEntity.ParentType
        {
            get
            {
                return typeof(SkeletalAnim);
            }
        }

        public int SmoothSkinningMatrixIndex
        {
            get
            {
                return this.@smoothSkinningMatrixIndex;
            }

            set
            {
                if (this.@smoothSkinningMatrixIndex == value)
                {
                    return;
                }

                this.SetProperty(ref this.@smoothSkinningMatrixIndex, value, () => this.CalcCRC());
            }
        }

        public int RigidSkinningMatrixIndex
        {
            get
            {
                return this.@rigidSkinningMatrixIndex;
            }

            set
            {
                if (this.@rigidSkinningMatrixIndex == value)
                {
                    return;
                }

                this.SetProperty(ref this.@rigidSkinningMatrixIndex, value, () => this.CalcCRC());
            }
        }

        /// <summary>
        /// 出力データを作成します。
        /// </summary>
        /// <returns>出力データのインスタンスを返します。</returns>
        public override bone_animType CreateSerializableData()
        {
            var writeData = new bone_animType();
            writeData.@name = this.Name;
            {
                Ensure.Operation.NotNull(this.parent);
                IEnumerable<KeyValuePair<bone_anim_target_targetType, BoneAnimTarget>> targets = this.BoneAnimTargets;
                if (this.parent.SkeletalAnimInfo.RotateMode == skeletal_anim_info_rotate_modeType.euler_xyz)
                {
                    targets = this.BoneAnimTargets.Where(x => x.Value.Target != bone_anim_target_targetType.rotate_w);
                }
                writeData.bone_anim_target = targets
                    .Select(x => x.Value.CreateSerializableData())
                    .ToArray();
            }
            if (this.@UserDatas.Count > 0)
            {
                writeData.@user_data_array = new user_data_arrayType();
                writeData.@user_data_array.Items = this.@userDatas.Select(x => x.CreateSerializableData()).Where(x => x != null).ToArray();
                if (writeData.@user_data_array.Items.Length == 0)
                {
                    writeData.@user_data_array = null;
                }
            }
            writeData.@bone_name = this.BoneName;
            writeData.@parent_name = this.ParentName;
            writeData.@rigid_body = this.RigidBody;
            writeData.@scale_compensate = this.ScaleCompensate;
            writeData.@binarize_scale = this.BinarizeScale;
            writeData.@binarize_rotate = this.BinarizeRotate;
            writeData.@binarize_translate = this.BinarizeTranslate;
            writeData.@compress_enable = this.CompressEnable;
            writeData.matrix_index = new int[2];
            writeData.matrix_index[0] = this.SmoothSkinningMatrixIndex;
            writeData.matrix_index[1] = this.RigidSkinningMatrixIndex;
            return writeData;
        }

        /// <summary>
        /// 現在のインスタンスをディープコピーで複製した新規インスタンスを返します。
        /// </summary>
        BoneAnim IDeepCopyable<BoneAnim>.DeepCopy()
        {
            return new BoneAnim(this);
        }

        /// <summary>
        /// 入力ファイルからディープコピーします。
        /// </summary>
        /// <param name="source">コピー元となる入力ファイルです。</param>
        public void DeepCopyFrom(BoneAnim source)
        {
            this.@name = source.@name;
            CopyElements(source.@boneAnimTargets, this.@boneAnimTargets);
            CopyElements(source.@userDatas, this.@userDatas);
            this.@boneName = source.@boneName;
            this.@parentName = source.@parentName;
            this.@rigidBody = source.@rigidBody;
            this.@scaleCompensate = source.@scaleCompensate;
            this.@binarizeScale = source.@binarizeScale;
            this.@binarizeRotate = source.@binarizeRotate;
            this.@binarizeTranslate = source.@binarizeTranslate;
            this.@compressEnable = source.@compressEnable;
            this.@smoothSkinningMatrixIndex = source.@smoothSkinningMatrixIndex;
            this.@rigidSkinningMatrixIndex = source.@rigidSkinningMatrixIndex;
        }

        /// <summary>
        /// エンティティの CRC を作成します。（内部処理用）
        /// </summary>
        /// <returns>CRC の値を返します。</returns>
        protected override uint CreateCRCInternal()
        {
            CRC32 crc = new CRC32();
            List<byte> buffers = new List<byte>();
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.Name)));
            foreach (var elem in this.BoneAnimTargets)
            {
                buffers.AddRange(BitConverter.GetBytes(elem.Value.HashValue));
            }
            foreach (var elem in this.UserDatas)
            {
                buffers.AddRange(BitConverter.GetBytes(elem.HashValue));
            }
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.BoneName)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.ParentName)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.RigidBody)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.ScaleCompensate)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.BinarizeScale)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.BinarizeRotate)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.BinarizeTranslate)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.CompressEnable)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.SmoothSkinningMatrixIndex)));
            buffers.AddRange(BitConverter.GetBytes(crc.ComputeHashUInt32(this.RigidSkinningMatrixIndex)));
            return crc.ComputeHashUInt32(buffers.ToArray());
        }

        /// <summary>
        /// 自動計算フラグを設定します。(内部処理用）
        /// </summary>
        protected override void SetAutoCalcFlagInternal()
        {
            foreach (var elem in this.@boneAnimTargets)
            {
                elem.Value.AutoCalc = this.AutoCalc;
            }
            foreach (var elem in this.@userDatas)
            {
                elem.AutoCalc = this.AutoCalc;
            }
        }

        /// <summary>
        /// エンティティの状態をリセットします。(内部処理用）
        /// </summary>
        protected override void ResetInternal()
        {
            foreach (var elem in this.@boneAnimTargets)
            {
                elem.Value.Reset();
            }
            foreach (var elem in this.@userDatas)
            {
                elem.Reset();
            }
        }

        /// <summary>
        /// エンティティの状態を更新します。(内部処理用）
        /// </summary>
        protected override void RefreshInternal()
        {
            foreach (var elem in this.@boneAnimTargets)
            {
                elem.Value.Refresh();
            }
            foreach (var elem in this.@userDatas)
            {
                elem.Refresh();
            }
        }

        private void OnPropertyChanged(object sender, PropertyChangedEventArgs e)
        {
            if (e.PropertyName == "HashValue")
            {
                this.CalcCRC();
            }
        }
    }
}
