﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;

namespace App.Controls
{
    //--------------------------------------------------------------------------
    // UIControl ユーティリティクラス
    //--------------------------------------------------------------------------
    #region UIControlEventSuppressBlock
    /// <summary>
    /// ＵＩコントロールイベント抑制ブロッククラス。
    /// </summary>
    public sealed class UIControlEventSuppressBlock : IDisposable
    {
        // インスタンスリスト
        private static readonly List<UIControlEventSuppressBlock> _instances = new List<UIControlEventSuppressBlock>();

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public UIControlEventSuppressBlock()
        {
            // リストに追加
            _instances.Add(this);
        }

        /// <summary>
        /// 開放処理。
        /// </summary>
        public void Dispose()
        {
            // リストから削除
            _instances.Remove(this);
        }

        /// <summary>
        /// 抑制中かどうか。
        /// </summary>
        public static bool Enabled
        {
            get
            {
                // インスタンスがあれば抑制中
                return _instances.Count > 0;
            }
        }
    }
    #endregion
}
