﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace NintendoWare.ExtensionManager
{
    //==========================================================================
    /// <summary>
    /// Dialog to show when installation was successful
    /// </summary>
    //==========================================================================
    public partial class TerminateExplorerDialog : Form
    {
        //----------------------------------------------------------------------
        /// <summary>
        /// Constructor
        /// </summary>
        //----------------------------------------------------------------------
        public TerminateExplorerDialog()
        {
            InitializeComponent();
        }

        //----------------------------------------------------------------------
        /// <summary>
        /// Handle Ok
        /// </summary>
        //----------------------------------------------------------------------
        private void OnOk(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.OK;
            this.Close();
        }

        //----------------------------------------------------------------------
        /// <summary>
        /// Handle Cancel
        /// </summary>
        //----------------------------------------------------------------------
        private void OnCancel(object sender, EventArgs e)
        {
            this.DialogResult = DialogResult.Cancel;
            this.Close();
        }

        //----------------------------------------------------------------------
        /// <summary>
        /// Set Label for Install
        /// </summary>
        //----------------------------------------------------------------------
        public void SetInstallLabel()
        {
            this.m_InstallLabel1.Visible = true;
            this.m_InstallLabel2.Visible = true;
            this.m_UninstallLabel1.Visible = false;
            this.m_UninstallLabel2.Visible = false;
            this.m_GUILabel1.Visible = false;
            this.m_GUILabel2.Visible = false;
        }

        //----------------------------------------------------------------------
        /// <summary>
        /// Set Label for Uninstall
        /// </summary>
        //----------------------------------------------------------------------
        public void SetUninstallLabel()
        {
            this.m_InstallLabel1.Visible = false;
            this.m_InstallLabel2.Visible = false;
            this.m_UninstallLabel1.Visible = true;
            this.m_UninstallLabel2.Visible = true;
            this.m_GUILabel1.Visible = false;
            this.m_GUILabel2.Visible = false;
        }

        //----------------------------------------------------------------------
        /// <summary>
        /// Set Label for GUI
        /// </summary>
        //----------------------------------------------------------------------
        public void SetGUILabel()
        {
            this.m_InstallLabel1.Visible = false;
            this.m_InstallLabel2.Visible = false;
            this.m_UninstallLabel1.Visible = false;
            this.m_UninstallLabel2.Visible = false;
            this.m_GUILabel1.Visible = true;
            this.m_GUILabel2.Visible = true;
        }
    }
}
