﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Xml.Serialization;

/*
 * flan のスキーマに対応するクラスにメンバを付加している。
 * 自動生成されたほうのクラス定義には、
 * System.Diagnostics.DebuggerStepThroughAttribute
 * が付加されているので、デバッグでステップインできない。
 * そのため、複雑なメソッドの定義は避ける。
 */

namespace NW4F.LayoutBinaryConverter.Schema.Flan
{
    public partial class AnimTag
    {
        [XmlIgnore]
        public int FrameSize;

        public string GetFileName()
        {
            return fileName != null ? fileName: name;
        }
    }

    public partial class AnimTarget
    {
        /// <summary>
        /// AnimTargetを複製し、キー配列を差し替えたオブジェクトを返す。
        /// </summary>
        /// <param name="newKeys"></param>
        /// <returns></returns>
        public AnimTarget Duplicate(Hermite[] newKeys)
        {
            AnimTarget newAnimTarget = MemberwiseClone() as AnimTarget;
            newAnimTarget.key = newKeys;
            return newAnimTarget;
        }
    }

    public partial class RefRes
    {
        public Flyt.TexelFormat format;
        public bool isIndirect;

        public string GetFileName(bool isUseBntxTextureFormat)
        {
            // Bntx を利用する場合、テクスチャが一つのファイルに集約されるので、拡張子はつけない。
            string extention = isUseBntxTextureFormat ? "" : ".bflim";
            return name + Flyt.TextureFile.GetImagePostfix(format, isIndirect) + extention;
        }
    }

    public partial class Hermite
    {
        /// <summary>
        /// キーを複製して新しくフレーム値をセットする
        /// </summary>
        /// <param name="frame"></param>
        /// <returns></returns>
        public Hermite Duplicate(float frame)
        {
            Hermite newObj = MemberwiseClone() as Hermite;
            newObj.frame = frame;
            return newObj;
        }
    }
}
