﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.IO;

using rlyt = NW4F.LayoutBinaryConverter.Schema.Flyt;

namespace NW4F.LayoutBinaryConverter.TexConv
{
    public class ImageReader
    {
        public delegate int Reader(int rawSize, byte[] rawBits, SrcImage dfPtr); // pointer to 'read' function

        Dictionary<string, Reader> _imageReaderDic = new Dictionary<string, Reader>();

        public ImageReader()
        {}

        public void SetImageReader(string ext, Reader imageReader)
        {
            Debug.Assert(!string.IsNullOrEmpty(ext));
            Debug.Assert(imageReader != null);

            _imageReaderDic[ext.ToUpperInvariant()] = imageReader;
        }

        public SrcImage Read(string fileName)
        {
            Debug.Assert(!string.IsNullOrEmpty(fileName));
            Debug.Assert(Path.HasExtension(fileName));

            string ext = Path.GetExtension(fileName).Substring(1).ToUpperInvariant();
            Reader imageReader = _imageReaderDic[ext];

            SrcImage file = new SrcImage();
            file.name = fileName;
            file.lyColor = null;
            file.lyAlpha = null;
            file.palPtr = null;

            byte[] rawBits = File.ReadAllBytes(fileName);

            // call file reading function
            imageReader(rawBits.Length, rawBits, file);

            // return a ptr to the decoded file in the file cache
            return file;
        }
    }

}
