﻿#pragma once
//--------------------------------------------------------------------------------
//  Assert
//
#ifndef NW_ASSERT
#define NW_ASSERT(exp) \
            NW_TASSERTMSG( (exp), "NW:Failed assertion " #exp )
#endif

//--------------------------------------------------------------------------------
//  Err
//
#ifndef NW_ERR
#define NW_ERR(...) \
    { NW_TASSERTMSG(false, __VA_ARGS__); }
#endif

#if _DEBUG
#define NW_TASSERTMSG(exp, ... )     \
          if(!((void)0, exp)) { sharc::debug::HaltWithDetail(__FUNCTION__, __LINE__, __VA_ARGS__); }
#else
#if defined(_MSC_VER) && _MSC_VER >= 1700
#define NW_TASSERTMSG(exp, ...) do { (void)(exp); } while((void)0, 0)
#else
#define NW_TASSERTMSG(exp, ...) do { (void)sizeof(exp); } while((void)0, 0)
#endif
#endif

namespace sharc
{
    namespace debug
    {
        //---------------------------------------------------------------------------
        //! @brief        メッセージ付きでプログラムを異常終了します。
        //!
        //! @param[in]    codePos ファイル名
        //! @param[in]    lineNo  行番号
        //! @param[in]    format  出力文字列のフォーマット
        //---------------------------------------------------------------------------
        void HaltWithDetail(const char* codePos, int lineNo, const char* format, ...);
    }
}
