﻿#include "FontInfoGetter.h"

namespace
{

// デコード
array<byte>^ Decode(array<byte>^ data)
{
    // デコード
    array<byte>^ data2 = gcnew array<byte>(data->Length);
    data->CopyTo(data2, 0);
    pin_ptr<byte> pinnedData = &data2[0];
    NintendoWare::FontInfoGetter::DecodeBfttf::Decode(pinnedData, data2->Length);

    // bfttf のヘッダ部分を削除
    const int headerSize = 0x08;
    array<byte>^ data3 = gcnew array<byte>(data2->Length - headerSize);
    for (int i = 0; i < data2->Length - headerSize; i++)
    {
        data3[i] = data2[i + headerSize];
    }
    return data3;
}

// アロケート
void* AllocateFunction(size_t size, size_t alignment, void* pUserData)
{
    return new char[size];
}

// デアロケート
void FreeFunction(void* ptr, void* pUserData)
{
    delete[] ptr;
}

// デシリアライズ
Object^ Deserialize(String^ path, System::Type^ type)
{
    XmlSerializer^ xmlSerializer = gcnew XmlSerializer(type);

    XmlReaderSettings^ settings = gcnew XmlReaderSettings();
    settings->CloseInput = false;
    settings->ValidationType = ValidationType::None;

    FileStream^ fileStream = gcnew FileStream(path, FileMode::Open, FileAccess::Read);
    XmlDocument^ xmlDocument = gcnew XmlDocument();
    xmlDocument->PreserveWhitespace = true;
    xmlDocument->Load(fileStream);
    XmlNodeReader^ xmlNodeReader = gcnew XmlNodeReader(xmlDocument);
    XmlReader^ xmlReader = XmlReader::Create(xmlNodeReader, settings);

    return xmlSerializer->Deserialize(xmlReader);
}

}

namespace NintendoWare { namespace FontInfoGetter {

// スケーラブルフォントの情報を取得します。
ScalableFontInfo^ FontInfoUtility::AcquireScalableFontInfo(String^ path)
{
    // フォントファイルのロード
    array<byte>^ fontData = File::ReadAllBytes(path);
    if (fontData == nullptr)
    {
        return nullptr;
    }

    // フォントエンジンの初期化
    nn::fontll::ScalableFontEngine engine;
    char fontNameBuffer[nn::fontll::FontNameLengthMax];
    const size_t workSize = 64 * 1024 * 1024;
    char* pWordBuf = new char[workSize];
    engine.Initialize(pWordBuf, workSize);
    nn::fontll::OtfKerningTable* pOtfKerningTable = NULL;

    // デコード
    String^ ext = Path::GetExtension(path)->ToLower();
    if (ext == ".bfttf")
    {
        fontData = Decode(fontData);
        ext = ".ttf";
    }
    if (ext == ".bfotf")
    {
        fontData = Decode(fontData);
        ext = ".otf";
    }

    // フォントの設定
    {
        pin_ptr<Byte> pinnedData = &fontData[0];
        engine.LoadFont(fontNameBuffer, pinnedData, 0, nn::fontll::FontNameLengthMax);
        engine.SetFont(fontNameBuffer);
    }

    // OTF のカーニングテーブルの取得
    if (ext == ".otf")
    {
        pOtfKerningTable = engine.InitializeOtfKerningTable(AllocateFunction, NULL);
    }

    // 情報の取得
    ScalableFontInfo^ scalableFontInfo = gcnew ScalableFontInfo();
    scalableFontInfo->metrics = AcquireMetrics(&engine);
    scalableFontInfo->glyphExistence = AcquireGlyphExistence(&engine);
    // 処理が重いためコメントアウト: scalableFontInfo->kerning = AcquireKerning(&engine);
    scalableFontInfo->kerningExistence = engine.CheckTtfKernTableExist();
    // 処理が重いためコメントアウト: scalableFontInfo->gposKerning = AcquireGposKerning(&engine, pOtfKerningTable);
    scalableFontInfo->gposKerningExistence = pOtfKerningTable != NULL;

    // 解放
    if (pOtfKerningTable != NULL)
    {
        engine.FinalizeOtfKerningTable(pOtfKerningTable, FreeFunction, NULL);
        pOtfKerningTable = NULL;
    }
    engine.Finalize();
    if (pWordBuf != NULL)
    {
        delete[] pWordBuf;
        pWordBuf = NULL;
    }
    return scalableFontInfo;
}

Metrics^ FontInfoUtility::AcquireMetrics(nn::fontll::ScalableFontEngine* pEngine)
{
    Metrics^ metrics = gcnew Metrics();
    nn::fontll::Metrics srcMetrics;
    if (pEngine->GetFontMetrics(&srcMetrics) != nn::fontll::Success)
    {
        return nullptr;
    }

    metrics->unitsPerEm = srcMetrics.unitsPerEm;
    metrics->headMacStyle = srcMetrics.headMacStyle;
    metrics->os2WinAscent = srcMetrics.os2WinAscent;
    metrics->os2WinDescent = srcMetrics.os2WinDescent;
    metrics->os2Ascent = srcMetrics.os2Ascent;
    metrics->os2Descent = srcMetrics.os2Descent;
    metrics->os2FsSelection = srcMetrics.os2FsSelection;
    metrics->os2Leading = srcMetrics.os2Leading;
    metrics->hheaAscent = srcMetrics.hheaAscent;
    metrics->hheaDescent = srcMetrics.hheaDescent;
    metrics->hheaLeading = srcMetrics.hheaLeading;
    metrics->embeddingBits = srcMetrics.embeddingBits;
    metrics->fontBoundingBox = gcnew BoundingBox();
    metrics->fontBoundingBox->xMin = srcMetrics.fontBoundingBox.xMin;
    metrics->fontBoundingBox->yMin = srcMetrics.fontBoundingBox.yMin;
    metrics->fontBoundingBox->xMax = srcMetrics.fontBoundingBox.xMax;
    metrics->fontBoundingBox->yMax = srcMetrics.fontBoundingBox.yMax;
    metrics->fontInTtcCount = srcMetrics.fontInTtcCount;
    metrics->indexInTtc = srcMetrics.indexInTtc;
    metrics->fontName = marshal_as<String^>(srcMetrics.fontName);
    metrics->fontFamilyName = marshal_as<String^>(srcMetrics.fontFamilyName);
    metrics->copyright = marshal_as<String^>(srcMetrics.copyright);
    metrics->metricsResolution = srcMetrics.metricsResolution;
    metrics->glyphCount = srcMetrics.glyphCount;
    metrics->iconCount = srcMetrics.iconCount;

    return metrics;
}

array<Char>^ FontInfoUtility::AcquireGlyphExistence(nn::fontll::ScalableFontEngine* pEngine)
{
    List<Char>^ glyphExistenceList = gcnew List<Char>();
    for (int i = 0; i < GlyphMax; i++)
    {
        if (pEngine->CheckGlyphExist(i))
        {
            glyphExistenceList->Add(i);
        }
    }
    return glyphExistenceList->ToArray();
}

array<Kerning^>^ FontInfoUtility::AcquireKerning(nn::fontll::ScalableFontEngine* pEngine)
{
    if (!pEngine->CheckTtfKernTableExist())
    {
        return gcnew array<Kerning^>(0);
    }

    List<Kerning^>^ kerningList = gcnew List<Kerning^>();
    nn::fontll::Fixed32 x;
    nn::fontll::Fixed32 y;
    for (int i = 0; i < GlyphMax; i++)
    {
        for (int j = 0; j < GlyphMax; j++)
        {
            if (pEngine->GetKerning(&x, &y, i, j) == nn::fontll::Success && x != 0)
            {
                Kerning^ kerning = gcnew Kerning();
                kerning->code1 = i;
                kerning->code2 = j;
                kerning->value = x >> 16;
                kerningList->Add(kerning);
            }
        }
    }
    return kerningList->ToArray();
}

array<Kerning^>^ FontInfoUtility::AcquireGposKerning(nn::fontll::ScalableFontEngine* pEngine, nn::fontll::OtfKerningTable* pOtfKerningTable)
{
    if (pOtfKerningTable == NULL)
    {
        return gcnew array<Kerning^>(0);
    }

    List<Kerning^>^ kerningList = gcnew List<Kerning^>();

    for (int i = 0; i < GlyphMax; i++)
    {
        // 先頭の文字におけるカーニング
        {
            int value = pEngine->AcquireRawOtfKerningFirst(pOtfKerningTable, i);
            if (value != 0)
            {
                Kerning^ kerning = gcnew Kerning();
                kerning->code1 = 0;
                kerning->code2 = i;
                kerning->value = value;
                kerningList->Add(kerning);
            }
        }
        // 末尾の文字におけるカーニング
        {
            int value = pEngine->AcquireRawOtfKerningLast(pOtfKerningTable, i);
            if (value != 0)
            {
                Kerning^ kerning = gcnew Kerning();
                kerning->code1 = i;
                kerning->code2 = 0;
                kerning->value = value;
                kerningList->Add(kerning);
            }
        }
        // 2 つの文字におけるカーニング
        for (int j = 0; j < GlyphMax; j++)
        {
            int value = pEngine->AcquireRawOtfKerning(pOtfKerningTable, i, j);
            if (value != 0)
            {
                Kerning^ kerning = gcnew Kerning();
                kerning->code1 = i;
                kerning->code2 = j;
                kerning->value = value;
                kerningList->Add(kerning);
            }
        }
    }
    return kerningList->ToArray();
}

} } // namespace NintendoWare::FontInfoGetter
