﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FcpxMaker
{
    public class Type
    {
        /// <summary>
        /// データの種類です。
        /// </summary>
        public enum DataType
        {
            None = 0,
            Root,
            PairFont,
            BitmapFont,
            ScalableFont,
            MultiScalableFont,
            ScalableFontDescription,
            Font,
        }

        /// <summary>
        /// イベントの種類です。
        /// </summary>
        public enum EventType
        {
            New,             // 新規作成
            Open,            // 開く
            Close,           // 閉じる
            SelectedNode,    // ノードが選択された
            AddFont,         // フォントが追加された
            RemoveFont,      // フォントが削除された
            ModifyFont,      // フォントが変更された
            Replace,         // フォントが入れ替わった
            AfterReplace,    // フォントが入れ替わった(後処理用)
            Save,            // 上書き保存
            SaveAs,          // 名前を付けて保存
            Exit,            // 終了
            DialogClose,     // ダイアログが閉じられた
            UpdateTreeView,  // ツリービューを更新する
            DataModified,    // データが変更された
            CopyClipBoard,   // クリップボードにコピーされた
            PasteParams,     // パラメータがペーストされた
        }

        /// <summary>
        /// フォントの種類です。
        /// </summary>
        public enum FontFileType
        {
            All,
            Bitmap,
            Scalable,
            Fcpx,
        }

        /// <summary>
        /// 警告ダイアログの種類です。
        /// </summary>
        public enum WarningDialogType
        {
            FileNew,
            AppClose,
            RemoveFont,
            DocumentNotFound,
            FileTypeError,
        }
    }
}
