﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FcpxMaker
{
    using DataModel;
    using Node;
    using Panel.Property;
    using static FcpxMaker.Type;

    public partial class PairFontPropertyPanel : PropertyPanelBase
        , IEventListener
    {
        /// <summary>
        /// 操作対象のデータモデルです。
        /// </summary>
        private PairFontDataModel TargetDataModel
        {
            get
            {
                return Target as PairFontDataModel;
            }
        }

        /// <summary>
        /// UIを更新します。
        /// </summary>
        override public void UpdateProperty()
        {
            if (TargetDataModel != null)
            {
                _tbxFont1Type.Text = TargetDataModel.Font1Type.ToString();
                _tbxFont2Type.Text = TargetDataModel.Font2Type.ToString();
            }
        }

        /// <summary>
        ///コンストラクタです。
        /// </summary>
        public PairFontPropertyPanel()
        {
            InitializeComponent();
        }

        /// <summary>
        /// イベントを通知します。
        /// </summary>
        public void dispatch(object sender, EventArgs arg)
        {
            EventParam param = arg as EventParam;

            switch (param.Type)
            {
                case EventType.AddFont:
                case EventType.PasteParams:
                    {
                        UpdateProperty();
                    }
                    break;
                case EventType.Replace:
                    {
                        DataModelBase tmp = TargetDataModel.FirstFont;
                        TargetDataModel.FirstFont = TargetDataModel.SecondFont;
                        TargetDataModel.SecondFont = tmp;

                        UpdateProperty();
                    }
                    break;
            }
        }

        /// <summary>
        /// 入れ替えボタンが押されたときのイベントハンドラ。
        /// </summary>
        private void Event_ReplaceClick(object sender, EventArgs e)
        {
            EventParam args = new EventParam(EventType.Replace, null);
            EventManager.entry(sender, args);

            // データの変更を通知します
            NotifyDataModified();
        }
    }
}
