﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace FcpxMaker.Dialog
{
    using static FcpxMaker.Type;

    public partial class WarningDialog : Form
    {
        private DialogResult _result = DialogResult.None;

        /// <summary>
        /// 名前をつけて保存後のコールバックを指定します。
        /// </summary>
        public Action SaveAsPostCallback { get; set; }

        /// <summary>
        /// ダイアログを表示します。
        /// </summary>
        public void Appear(WarningDialogType type)
        {
            switch (type)
            {
                case WarningDialogType.FileNew:
                    {
                        _lblText.Text = Properties.Resources.DIALOG_MESSAGE_FILENEW;
                    }
                    break;
                case WarningDialogType.AppClose:
                    {
                        _lblText.Text = Properties.Resources.DIALOG_MESSAGE_APPCLOSE;
                    }
                    break;
                case WarningDialogType.RemoveFont:
                    {
                        this.Text = Properties.Resources.DIALOG_TITLE_NODE_REMOVE;
                        _lblText.Text = Properties.Resources.DIALOG_MESSAGE_NODE_REMOVE;
                        _btnSaveAs.Visible = false;
                    }
                    break;
                case WarningDialogType.DocumentNotFound:
                    {
                        _lblText.Text = Properties.Resources.DIALOG_MESSAGE_DOCUMENT_NOTFOUND;
                        _btnSaveAs.Visible = false;
                    }
                    break;
                case WarningDialogType.FileTypeError:
                    {
                        _lblText.Text = Properties.Resources.DIALOG_MESSAGE_FONTTYPE_ERROR;
                        _btnSaveAs.Visible = false;
                        _btnCancel.Visible = false;
                        _btnOk.Location = _btnCancel.Location;
                    }
                    break;
            }

            this.StartPosition = FormStartPosition.CenterParent;
            this.ShowDialog();
        }

        /// <summary>
        /// ダイアログの結果を取得します。
        /// </summary>
        public DialogResult GetResult()
        {
            return _result;
        }

        public WarningDialog()
        {
            InitializeComponent();
        }

        /// <summary>
        /// 名前をつけて保存が押された時のイベントハンドラです。
        /// </summary>
        private void Event_SaveAsClick(object sender, EventArgs e)
        {
            // ファイルを選択する
            if (FileIOManager.ShowFcpxSaveDialog() == DialogResult.OK)
            {
                EventParam args = new EventParam(EventType.SaveAs, FileIOManager.FcpxSaveFilePath);
                EventManager.entry(sender, args);

                if (SaveAsPostCallback != null)
                {
                    SaveAsPostCallback();
                }

                this.Close();
            }
        }

        /// <summary>
        /// OKが押された時のイベントハンドラです。
        /// </summary>
        private void Event_OkClick(object sender, EventArgs e)
        {
            _result = DialogResult.OK;
        }

        /// <summary>
        /// Cancelが押された時のイベントハンドラです。
        /// </summary>
        private void Event_CancelClick(object sender, EventArgs e)
        {
            _result = DialogResult.Cancel;
        }

        /// <summary>
        /// フォームが閉じた時のイベントハンドラです。
        /// </summary>
        private void Event_FormClosed(object sender, FormClosedEventArgs e)
        {
            EventParam args = new EventParam(EventType.DialogClose, null);
            EventManager.entry(sender, args);
        }
    }
}
