﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;

namespace LayoutEditor.Structures.SerializableObject
{
    using LECore.Structures;
    /// <summary>
    /// 安全フレーム
    /// </summary>
    public struct SafeFrame
    {
        int      _leftWidth;
        int      _rightWidth;
        int      _topWidth;
        int      _bottomWidth;

        Color    _color;
        bool     _visible;


        #region プロパティ
        public RGBAColor RGBAColor
        {
            get{ return new RGBAColor( _color ); }
            set{ _color = value.AsColor; }
        }

        public int IntColor
        {
            get { return _color.ToArgb(); }
            set { _color = Color.FromArgb( value ); }
        }

        public int      LeftWidth
        {
            get{ return _leftWidth;}
            set{ _leftWidth = value;}
        }

        public int      RightWidth
        {
            get{ return _rightWidth;}
            set{ _rightWidth = value;}
        }

        public int      TopWidth
        {
            get{ return _topWidth;}
            set{ _topWidth = value;}
        }

        public int      BottomWidth
        {
            get{ return _bottomWidth;}
            set{ _bottomWidth = value;}
        }

        public bool     Visible
        {
            get{ return _visible;}
            set{ _visible = value;}
        }

        #endregion プロパティ

        static public bool Same( SafeFrame lhs, SafeFrame rhs )
        {
            return
                lhs.IntColor == rhs.IntColor &&
                lhs.LeftWidth == rhs.LeftWidth &&
                lhs.RightWidth == rhs.RightWidth &&
                lhs.TopWidth == rhs.TopWidth &&
                lhs.BottomWidth == rhs.BottomWidth &&
                lhs.Visible == rhs.Visible;

        }

        public SafeFrame( int l, int r, int t, int b, bool bVisible, Color color )
        {
            _leftWidth   = l;
            _rightWidth  = r;
            _topWidth    = t;
            _bottomWidth = b;

            _color    = color;
            _visible  = bVisible;
        }

        public SafeFrame( SafeFrame src )
            :this(
            src.LeftWidth,
            src.RightWidth,
            src.TopWidth,
            src.BottomWidth,
            src.Visible,
            src.RGBAColor.AsColor )
        {
        }
    }
}
