﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using LECore.Structures;
using System.Diagnostics;

namespace LayoutEditor.src.Forms.ToolWindows.StateSettingWindow
{
    public partial class EditStateOneNameChoicePanel : UserControl
    {
        public EditStateOneNameChoicePanel()
        {
            InitializeComponent();
        }

        public string String1 { get { return _cmbName1.Text; } }
        public string String2 { get { return _cmbName2.Text; } }

        class NameEntry
        {
            private string _text;
            public IEnumerable<string> _subTexts { get; private set; }

            public NameEntry(string text, IEnumerable<string> subTexts)
            {
                _text = text;
                _subTexts = subTexts;
            }

            public override string ToString()
            {
                return _text;
            }
        }

        public void Setup(string nameLable1, string[] names1, string name1, string nameLable2, IEnumerable<string>[] namesArray, string name2)
        {
            _lbl1.Text = nameLable1;
            _lbl2.Text = nameLable2;

            Debug.Assert((names1 == null && namesArray == null) || names1.Length == namesArray.Length);

            _cmbName1.Items.Clear();
            if(names1.Any())
            {
                for (int i = 0; i < names1.Length; i++)
                {
                    _cmbName1.Items.Add(new NameEntry(names1[i], namesArray[i]));
                }
                _cmbName1.SelectedIndex = _cmbName1.FindStringExact(name1);
            }

            _cmbName1_SelectedIndexChanged(null, null);

            _cmbName2.SelectedIndex = _cmbName2.FindStringExact(name2);
        }

        private void _cmbName1_SelectedIndexChanged(object sender, EventArgs e)
        {
            var entry = _cmbName1.SelectedItem as NameEntry;
            if(entry == null)
            {
                return;
            }

            _cmbName2.Items.Clear();
            foreach (var subText in entry._subTexts)
            {
                _cmbName2.Items.Add(subText);
            }
        }
    }
}
