﻿using LECore.Structures;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace LayoutEditor.src.Forms.ToolWindows.StateSettingWindow
{
    public partial class EditFeatureParamaterDlg : Form
    {
        public EditFeatureParamaterDlg()
        {
            InitializeComponent();

            {
                _cmbEasingKind.Items.Clear();
                foreach (var kind in Enum.GetValues(typeof(EasingType)))
                {
                    _cmbEasingKind.Items.Add(kind.ToString());
                }
            }
        }

        private Action _OnOkAction { get; set; }

        public IState State { get; private set; }
        public IFeatureParamater FeatureParamater { get; private set; }

        public EasingType EasingType
        {
            get
            {
                EasingType type = EasingType.Linear;

                if (_cmbEasingKind.SelectedItem != null)
                {
                    Enum.TryParse<EasingType>(_cmbEasingKind.SelectedItem.ToString(), out type);
                }
                return type;
            }
        }

        public float EasingExtraParamater { get { return (float)_nudEasingParamater.Value; } set { _nudEasingParamater.Value = (Decimal)value; } }

        public float Time { get; private set; }

        public float X { get { return (float)_nudX.Value; } }

        public float Y { get { return (float)_nudY.Value; } }

        public float Z { get { return (float)_nudZ.Value; } }

        public float W { get { return (float)_nudW.Value; } }

        //----------------------------------------------------------
        public void Setup(IStateMachine stateMachine, IState state, IFeatureParamater paramater, Action onOkAction)
        {
            Setup(stateMachine, state, paramater, IStateEasingHelper.Empty, 0.0f, onOkAction);
            _cmbEasingKind.Enabled = false;
            _nudEasingParamater.Enabled = false;
        }

        public void Setup(IStateMachine stateMachine, IState state, IFeatureParamater paramater, IStateEasing stateEasing, float time, Action onOkAction)
        {
            _OnOkAction = onOkAction;
            _cmbEasingKind.Enabled = true;
            _nudEasingParamater.Enabled = true;

            this.Time = time;

            var layer = stateMachine.GetSelectedIStateLayer();
            if (layer == null)
            {
                Debug.Assert(false);
                return;
            }

            _cmbEasingKind.SelectedIndex = _cmbEasingKind.FindStringExact(stateEasing.EasingType.ToString());
            _nudEasingParamater.Value = (decimal)stateEasing.EasingExtraParamater;

            Debug.Assert(state != null);
            State = state;
            FeatureParamater = paramater;

            _tbxName.Text = paramater.Name;
            _tbxKind.Text = paramater.Kind.ToString();

            _nudX.Value = (Decimal)paramater.X;
            _nudY.Value = (Decimal)paramater.Y;
            _nudZ.Value = (Decimal)paramater.Z;
            _nudW.Value = (Decimal)paramater.W;

            _cmbEasingKind_SelectedIndexChanged(null, null);
        }

        void UpdateButtons_()
        {
            bool isValid = true;
            _btnOK.Enabled = isValid;
        }

        //----------------------------------------------------------

        private void AddPropertyDlg_Deactivate(object sender, EventArgs e)
        {
            this.Hide();
        }

        //----------------------------------------------------------

        public void ShowInEditMode()
        {
            Show();
        }

        //----------------------------------------------------------

        private void _btnOK_Click(object sender, EventArgs e)
        {
            if(_OnOkAction != null)
            {
                _OnOkAction();
            }

            this.Hide();
        }

        private void _cmbEasingKind_SelectedIndexChanged(object sender, EventArgs e)
        {
            _nudEasingParamater.Enabled = this.EasingType.UseExtraParamater();
        }
    }
}
