﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using LECore.Util;
using LECore.Structures;



namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    using Adapters;
    using LayoutEditor.Utility;

    /// <summary>
    /// オブジェクトプロパティダイアログの選択ターゲットボックスクラス。
    /// </summary>
    public class PropWndTargetBox : Panel
    {
        // ターゲット
        private PaneGuiAdapterGroup _target = new PaneGuiAdapterGroup();
        private string _lastPaneName = string.Empty;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public PropWndTargetBox()
        {
            this.BackColor   = SystemColors.Window;
            this.SetStyle( ControlStyles.DoubleBuffer | ControlStyles.AllPaintingInWmPaint | ControlStyles.UserPaint | ControlStyles.Opaque | ControlStyles.ResizeRedraw, true );
        }

        /// <summary>
        /// ターゲット。
        /// </summary>
        public PaneGuiAdapterGroup Target
        {
            get { return _target; }
            set
            {
                _target = value;
                Invalidate();
            }
        }

        /// <summary>
        /// 変更されていれば再描画。
        /// </summary>
        public void InvalidateIfChanged()
        {
            string newPaneName = (_target == null || _target.Active == null) ? "" : _target.Active.Name;
            if(this._lastPaneName != newPaneName)
            {
                this.Invalidate();
                this._lastPaneName = newPaneName;
            }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnPaint(PaintEventArgs e)
        {
            // 背景
            e.Graphics.Clear(this.BackColor);

            if (this.DesignMode)
                return;

            // ターゲット
            Rectangle rect = this.ClientRectangle;
            if (_target != null && !_target.IsEmpty)
            {
                // アイコン
              	Rectangle rectIcon = rect;
                const int iconSize = 16;
                rectIcon.X   += 2;
                rectIcon.Y += (rectIcon.Height - iconSize) / 2;
                rectIcon.Size = new Size(iconSize, iconSize);

                e.Graphics.DrawImage(PaneItemImageHelper.GetPaneImage(_target.Active.Target), rectIcon);

                // 名前
                Rectangle rectText = rect;
                RectangleUtil.OffsetLeft(ref rectText, rectIcon.Width + 2);
                using (StringFormat sf = new StringFormat())
                {
                    sf.Alignment     = StringAlignment.Near;
                    sf.LineAlignment = StringAlignment.Center;
                    sf.Trimming      = StringTrimming.EllipsisCharacter;
                    sf.FormatFlags  |= StringFormatFlags.NoWrap;

                  e.Graphics.DrawString(_target.Active.Name, AppConfig.Inst.GuiFontBold, SystemBrushes.WindowText, rectText, sf);
                }
            }
        }
    }
}
