﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using LayoutEditor.Structures.SerializableObject;
using LECore.Structures;

namespace LayoutEditor.Forms.ToolWindows
{
    public partial class SelectUserDataPresetDlg : Form
    {
        public event EventHandler ListClicked;

        /// <summary>
        ///
        /// </summary>
        public SelectUserDataPresetDlg()
        {
            InitializeComponent();
        }

        /// <summary>
        ///
        /// </summary>
        public void SetUserDataPresets(IEnumerable<ExUserDataPreset> userDataPresets, Func<ExUserDataPreset, bool> isTargetCheckFunc)
        {
            // プリセット候補選択リストを作成
            _lvwPreset.GridLines = true;
            if (userDataPresets.Count() > 0)
            {
                _lvwPreset.Items.Clear();
                foreach (var userDataPreset in userDataPresets)
                {
                    // フィルタ処理
                    if (isTargetCheckFunc != null && isTargetCheckFunc(userDataPreset) == false)
                    {
                        continue;
                    }

                    ListViewItem lvi = new ListViewItem(userDataPreset.Name);
                    lvi.Tag = userDataPreset;
                    lvi.SubItems.Add(userDataPreset.Type);
                    lvi.SubItems.Add(userDataPreset.Descriptions);

                    _lvwPreset.Items.Add(lvi);
                }

                // 結果としてリストが空の場合
                if (_lvwPreset.Items.Count == 0)
                {
                    _lvwPreset.GridLines = false;

                    ListViewItem lvi = new ListViewItem("");
                    lvi.Tag = new ExUserDataPreset();
                    lvi.SubItems.Add("");
                    lvi.SubItems.Add(StringResMgr.Get("PROP_NO_USERDATAPRESET_PANEKIND"));
                    _lvwPreset.Items.Add(lvi);
                }
            }
            else
            {
                _lvwPreset.Items.Clear();
                _lvwPreset.GridLines = false;

                // プリセット設定がが存在しない場合はユーザに設定方法を案内する。
                ListViewItem lvi = new ListViewItem("");
                lvi.Tag = new ExUserDataPreset();
                lvi.SubItems.Add("");
                lvi.SubItems.Add(StringResMgr.Get("PROP_NO_USERDATAPRESET"));
                _lvwPreset.Items.Add(lvi);
            }

            // サイズ調整
            using (Graphics gfx = Graphics.FromHwnd(_lvwPreset.Handle))
            {
                int nameMaxW = 0;
                int kindMaxW = 0;
                int descMaxW = 0;
                foreach (ListViewItem item in _lvwPreset.Items)
                {
                    nameMaxW = Math.Max((int)gfx.MeasureString(item.SubItems[0].Text, _lvwPreset.Font).Width, nameMaxW);
                    kindMaxW = Math.Max((int)gfx.MeasureString(item.SubItems[1].Text, _lvwPreset.Font).Width, kindMaxW);
                    descMaxW = Math.Max((int)gfx.MeasureString(item.SubItems[2].Text, _lvwPreset.Font).Width, descMaxW);
                }

                nameMaxW = Math.Min(240, nameMaxW);
                descMaxW = Math.Min(600, descMaxW);

                const int Margin = 8;
                _lvwPreset.Columns[0].Width = nameMaxW + Margin;
                _lvwPreset.Columns[1].Width = kindMaxW + Margin;
                _lvwPreset.Columns[2].Width = descMaxW + Margin;

                this.Size = new Size(nameMaxW + kindMaxW + descMaxW + (4 * Margin), Math.Min(15, _lvwPreset.Items.Count) * _lvwPreset.Items[0].Bounds.Height + 10);
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_lvwPreset_Click(object sender, EventArgs e)
        {
            if (ListClicked != null)
            {
                ListClicked(sender, e);
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void Event_lvwPreset_MouseMove(object sender, MouseEventArgs e)
        {
            Point _LvwMainPointToClient = _lvwPreset.PointToClient(new Point(e.X, e.Y));
            var node = _lvwPreset.GetItemAt(e.X, e.Y);
            if (node != null) { node.Focused = true; node.Selected = true; }

            _lvwPreset.Invalidate();
        }
    }
}
