﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Diagnostics;
using System.Windows.Forms;
using System.IO;
using System.Linq;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    using LayoutEditor.Controls;
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters;
    using LayoutEditor.Utility;

    using LECore.Manipulator;
    using LECore.Structures;
    using LECore;
    using LECore.Structures.Core;
    using System.Collections.Generic;

    /// <summary>
    /// ScissorPanePage の概要の説明です。
    /// </summary>
    public class ScissorPanePage : PropertyPage
    {
        private Label _lblDescription;
        #region デザイナメンバ



        #endregion デザイナメンバ

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ScissorPanePage()
        {
            InitializeComponent();
        }

        /// <summary>
        /// 捜査対象ペインアダプタ
        /// </summary>
        PaneGUIAdapter _TargetPane
        {
            get
            {
                PaneGUIAdapter paneAdapter = Target.Active;
                return paneAdapter;
            }
        }

        /// <summary>
        /// 操作対象ペインを操作するクラスを取得します。
        /// </summary>
        protected ScissorManipulator _TargetScissorMnp
        {
            get
            {
                return _TargetPane.FindTargetScissorManipulator(_TargetIndex);
            }
        }

        /// <summary>
        /// 複数が対象にある場合に、何番目を対象とするかを指定します。
        /// </summary>
        protected int _TargetIndex
        {
            get;
            set;
        }

        /// <summary>
        /// プロパティ初期化。
        /// </summary>
        protected override void InitializeProperty()
        {
            // GUIに関するユーザ独自の初期化処理を記述します。
        }

        /// <summary>
        /// GUIを更新します。
        /// </summary>
        protected override void UpdateProperty()
        {
        }

        #region デザイナ生成コード
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(ScissorPanePage));
            this._lblDescription = new System.Windows.Forms.Label();
            this.SuspendLayout();
            //
            // _lblDescription
            //
            resources.ApplyResources(this._lblDescription, "_lblDescription");
            this._lblDescription.Name = "_lblDescription";
            //
            // ScissorPanePage
            //
            this.Controls.Add(this._lblDescription);
            this.Name = "ScissorPanePage";
            this.ResumeLayout(false);

        }
        #endregion デザイナ生成コード

        /// <summary>
        /// インスタンス作成。
        /// </summary>
        public static PropertyPage CreateInstance(object arg)
        {
            var newInstance = new ScissorPanePage();
            newInstance._TargetIndex = (arg == null) ? 0 : (int)arg;

            return newInstance;
        }
    }
}

