﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;


namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.MaterialPages
{
    using LayoutEditor.Controls;
    using LayoutEditor.Utility;
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters ;
    using LECore.Structures.Nsrif.Attributes;

    using App = LayoutEditor;

    /// <summary>
    /// マテリアルＴＥＶステージページクラス。
    /// </summary>
    public sealed class MaterialTevStagePage : MaterialPage
    {
        #region デザイナ変数

        private App.Controls.UIRadioButton radStage0;
        private App.Controls.UIRadioButton radStage1;
        private App.Controls.UIRadioButton radStage2;
        private App.Controls.UIRadioButton radStage3;
        private App.Controls.UIRadioButton radStage4;
        private App.Controls.UIRadioButton radStage5;
        private App.Controls.UIRadioButton radStage6;
        private App.Controls.UIRadioButton radStage7;
        private App.Controls.UIRadioButton radStage15;
        private App.Controls.UIRadioButton radStage14;
        private App.Controls.UIRadioButton radStage13;
        private App.Controls.UIRadioButton radStage12;
        private App.Controls.UIRadioButton radStage11;
        private App.Controls.UIRadioButton radStage10;
        private App.Controls.UIRadioButton radStage9;
        private App.Controls.UIRadioButton radStage8;
        private App.Forms.ToolWindows.PropertyEditWindow.MaterialPages.TevControls.TevColorStagePanel ctlColorStage;
        private App.Forms.ToolWindows.PropertyEditWindow.MaterialPages.TevControls.TevAlphaStagePanel ctlAlphaStage;
        private System.Windows.Forms.GroupBox grpStageNo;
        private System.Windows.Forms.Label labNumStages;
        private App.Controls.IntTextBox tbxNumStages;
        private System.Windows.Forms.GroupBox grpStage;
        private App.Controls.UIComboBox cmbTexMapSwap;
        private App.Controls.UIComboBox cmbRasSwap;
        private System.Windows.Forms.Label labTexMapSwap;
        private System.Windows.Forms.Label labRasSwap;
        private App.Controls.UIComboBox cmbTexMapOrder;
        private System.Windows.Forms.Label labColorStage;
        private System.Windows.Forms.Label labAlphaStageLine;
        private System.Windows.Forms.Label labAlphaStage;
        private System.Windows.Forms.Label labColorStageLine;
        private System.Windows.Forms.TabPage tabPage7;
        private App.Controls.UIComboBox cmbRasOrder;
        private System.Windows.Forms.Label labTexMapOrder;
        private System.Windows.Forms.Label labRasOrder;
        private LayoutEditor.Forms.ToolWindows.PropertyEditWindow.MaterialPages.TevControls.TevIndirectStagePanel ctlIndirectStage;
        private System.Windows.Forms.Label labIndirectStageLine;
        private System.Windows.Forms.Label labIndirectStage;
        private System.Windows.Forms.GroupBox _grpIndirectStage;
        private System.ComponentModel.IContainer components = null;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager( typeof( MaterialTevStagePage ) );
            //LECore.Structures.TevIndirectStage tevIndirectStage1 = new LECore.Structures.TevIndirectStage();
            this.labNumStages = new System.Windows.Forms.Label();
            this.tbxNumStages = new LayoutEditor.Controls.IntTextBox();
            this.grpStageNo = new System.Windows.Forms.GroupBox();
            this.radStage15 = new LayoutEditor.Controls.UIRadioButton();
            this.radStage14 = new LayoutEditor.Controls.UIRadioButton();
            this.radStage13 = new LayoutEditor.Controls.UIRadioButton();
            this.radStage12 = new LayoutEditor.Controls.UIRadioButton();
            this.radStage11 = new LayoutEditor.Controls.UIRadioButton();
            this.radStage10 = new LayoutEditor.Controls.UIRadioButton();
            this.radStage9 = new LayoutEditor.Controls.UIRadioButton();
            this.radStage8 = new LayoutEditor.Controls.UIRadioButton();
            this.radStage6 = new LayoutEditor.Controls.UIRadioButton();
            this.radStage5 = new LayoutEditor.Controls.UIRadioButton();
            this.radStage4 = new LayoutEditor.Controls.UIRadioButton();
            this.radStage3 = new LayoutEditor.Controls.UIRadioButton();
            this.radStage2 = new LayoutEditor.Controls.UIRadioButton();
            this.radStage1 = new LayoutEditor.Controls.UIRadioButton();
            this.radStage0 = new LayoutEditor.Controls.UIRadioButton();
            this.radStage7 = new LayoutEditor.Controls.UIRadioButton();
            this.tabPage7 = new System.Windows.Forms.TabPage();
            this.grpStage = new System.Windows.Forms.GroupBox();
            this.labColorStage = new System.Windows.Forms.Label();
            this.labAlphaStageLine = new System.Windows.Forms.Label();
            this.labAlphaStage = new System.Windows.Forms.Label();
            this.labColorStageLine = new System.Windows.Forms.Label();
            this.cmbTexMapSwap = new LayoutEditor.Controls.UIComboBox();
            this.cmbRasSwap = new LayoutEditor.Controls.UIComboBox();
            this.labTexMapSwap = new System.Windows.Forms.Label();
            this.labRasSwap = new System.Windows.Forms.Label();
            this.cmbTexMapOrder = new LayoutEditor.Controls.UIComboBox();
            this.cmbRasOrder = new LayoutEditor.Controls.UIComboBox();
            this.labTexMapOrder = new System.Windows.Forms.Label();
            this.labRasOrder = new System.Windows.Forms.Label();
            this.ctlColorStage = new LayoutEditor.Forms.ToolWindows.PropertyEditWindow.MaterialPages.TevControls.TevColorStagePanel();
            this.ctlAlphaStage = new LayoutEditor.Forms.ToolWindows.PropertyEditWindow.MaterialPages.TevControls.TevAlphaStagePanel();
            this.ctlIndirectStage = new LayoutEditor.Forms.ToolWindows.PropertyEditWindow.MaterialPages.TevControls.TevIndirectStagePanel();
            this._grpIndirectStage = new System.Windows.Forms.GroupBox();
            this.labIndirectStageLine = new System.Windows.Forms.Label();
            this.labIndirectStage = new System.Windows.Forms.Label();
            this.grpStageNo.SuspendLayout();
            this.grpStage.SuspendLayout();
            this._grpIndirectStage.SuspendLayout();
            this.SuspendLayout();
            //
            // labNumStages
            //
            resources.ApplyResources( this.labNumStages, "labNumStages" );
            this.labNumStages.Name = "labNumStages";
            //
            // tbxNumStages
            //
            resources.ApplyResources( this.tbxNumStages, "tbxNumStages" );
            this.tbxNumStages.MaxValue = 16;
            this.tbxNumStages.MinValue = 1;
            this.tbxNumStages.Name = "tbxNumStages";
            this.tbxNumStages.Value = 1;
            //
            // grpStageNo
            //
            this.grpStageNo.Controls.Add( this.radStage15 );
            this.grpStageNo.Controls.Add( this.radStage14 );
            this.grpStageNo.Controls.Add( this.radStage13 );
            this.grpStageNo.Controls.Add( this.radStage12 );
            this.grpStageNo.Controls.Add( this.radStage11 );
            this.grpStageNo.Controls.Add( this.radStage10 );
            this.grpStageNo.Controls.Add( this.radStage9 );
            this.grpStageNo.Controls.Add( this.radStage8 );
            this.grpStageNo.Controls.Add( this.radStage6 );
            this.grpStageNo.Controls.Add( this.radStage5 );
            this.grpStageNo.Controls.Add( this.radStage4 );
            this.grpStageNo.Controls.Add( this.radStage3 );
            this.grpStageNo.Controls.Add( this.radStage2 );
            this.grpStageNo.Controls.Add( this.radStage1 );
            this.grpStageNo.Controls.Add( this.radStage0 );
            this.grpStageNo.Controls.Add( this.radStage7 );
            this.grpStageNo.FlatStyle = System.Windows.Forms.FlatStyle.System;
            resources.ApplyResources( this.grpStageNo, "grpStageNo" );
            this.grpStageNo.Name = "grpStageNo";
            this.grpStageNo.TabStop = false;
            //
            // radStage15
            //
            resources.ApplyResources( this.radStage15, "radStage15" );
            this.radStage15.Name = "radStage15";
            //
            // radStage14
            //
            resources.ApplyResources( this.radStage14, "radStage14" );
            this.radStage14.Name = "radStage14";
            //
            // radStage13
            //
            resources.ApplyResources( this.radStage13, "radStage13" );
            this.radStage13.Name = "radStage13";
            //
            // radStage12
            //
            resources.ApplyResources( this.radStage12, "radStage12" );
            this.radStage12.Name = "radStage12";
            //
            // radStage11
            //
            resources.ApplyResources( this.radStage11, "radStage11" );
            this.radStage11.Name = "radStage11";
            //
            // radStage10
            //
            resources.ApplyResources( this.radStage10, "radStage10" );
            this.radStage10.Name = "radStage10";
            //
            // radStage9
            //
            resources.ApplyResources( this.radStage9, "radStage9" );
            this.radStage9.Name = "radStage9";
            //
            // radStage8
            //
            resources.ApplyResources( this.radStage8, "radStage8" );
            this.radStage8.Name = "radStage8";
            //
            // radStage6
            //
            resources.ApplyResources( this.radStage6, "radStage6" );
            this.radStage6.Name = "radStage6";
            //
            // radStage5
            //
            resources.ApplyResources( this.radStage5, "radStage5" );
            this.radStage5.Name = "radStage5";
            //
            // radStage4
            //
            resources.ApplyResources( this.radStage4, "radStage4" );
            this.radStage4.Name = "radStage4";
            //
            // radStage3
            //
            resources.ApplyResources( this.radStage3, "radStage3" );
            this.radStage3.Name = "radStage3";
            //
            // radStage2
            //
            resources.ApplyResources( this.radStage2, "radStage2" );
            this.radStage2.Name = "radStage2";
            //
            // radStage1
            //
            resources.ApplyResources( this.radStage1, "radStage1" );
            this.radStage1.Name = "radStage1";
            //
            // radStage0
            //
            resources.ApplyResources( this.radStage0, "radStage0" );
            this.radStage0.Name = "radStage0";
            //
            // radStage7
            //
            resources.ApplyResources( this.radStage7, "radStage7" );
            this.radStage7.Name = "radStage7";
            //
            // tabPage7
            //
            resources.ApplyResources( this.tabPage7, "tabPage7" );
            this.tabPage7.Name = "tabPage7";
            //
            // grpStage
            //
            this.grpStage.Controls.Add( this.labColorStage );
            this.grpStage.Controls.Add( this.labAlphaStageLine );
            this.grpStage.Controls.Add( this.labAlphaStage );
            this.grpStage.Controls.Add( this.labColorStageLine );
            this.grpStage.Controls.Add( this.cmbTexMapSwap );
            this.grpStage.Controls.Add( this.cmbRasSwap );
            this.grpStage.Controls.Add( this.labTexMapSwap );
            this.grpStage.Controls.Add( this.labRasSwap );
            this.grpStage.Controls.Add( this.cmbTexMapOrder );
            this.grpStage.Controls.Add( this.cmbRasOrder );
            this.grpStage.Controls.Add( this.labTexMapOrder );
            this.grpStage.Controls.Add( this.labRasOrder );
            this.grpStage.Controls.Add( this.ctlColorStage );
            this.grpStage.Controls.Add( this.ctlAlphaStage );
            this.grpStage.FlatStyle = System.Windows.Forms.FlatStyle.System;
            resources.ApplyResources( this.grpStage, "grpStage" );
            this.grpStage.Name = "grpStage";
            this.grpStage.TabStop = false;
            //
            // labColorStage
            //
            this.labColorStage.ForeColor = System.Drawing.Color.DarkRed;
            resources.ApplyResources( this.labColorStage, "labColorStage" );
            this.labColorStage.Name = "labColorStage";
            //
            // labAlphaStageLine
            //
            this.labAlphaStageLine.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            resources.ApplyResources( this.labAlphaStageLine, "labAlphaStageLine" );
            this.labAlphaStageLine.Name = "labAlphaStageLine";
            //
            // labAlphaStage
            //
            this.labAlphaStage.ForeColor = System.Drawing.Color.DarkRed;
            resources.ApplyResources( this.labAlphaStage, "labAlphaStage" );
            this.labAlphaStage.Name = "labAlphaStage";
            //
            // labColorStageLine
            //
            this.labColorStageLine.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            resources.ApplyResources( this.labColorStageLine, "labColorStageLine" );
            this.labColorStageLine.Name = "labColorStageLine";
            //
            // cmbTexMapSwap
            //
            this.cmbTexMapSwap.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            resources.ApplyResources( this.cmbTexMapSwap, "cmbTexMapSwap" );
            this.cmbTexMapSwap.Name = "cmbTexMapSwap";
            this.cmbTexMapSwap.SelectedItemData = null;
            //
            // cmbRasSwap
            //
            this.cmbRasSwap.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            resources.ApplyResources( this.cmbRasSwap, "cmbRasSwap" );
            this.cmbRasSwap.Name = "cmbRasSwap";
            this.cmbRasSwap.SelectedItemData = null;
            //
            // labTexMapSwap
            //
            resources.ApplyResources( this.labTexMapSwap, "labTexMapSwap" );
            this.labTexMapSwap.Name = "labTexMapSwap";
            //
            // labRasSwap
            //
            resources.ApplyResources( this.labRasSwap, "labRasSwap" );
            this.labRasSwap.Name = "labRasSwap";
            //
            // cmbTexMapOrder
            //
            this.cmbTexMapOrder.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            this.cmbTexMapOrder.DropDownWidth = 288;
            resources.ApplyResources( this.cmbTexMapOrder, "cmbTexMapOrder" );
            this.cmbTexMapOrder.Name = "cmbTexMapOrder";
            this.cmbTexMapOrder.SelectedItemData = null;
            //
            // cmbRasOrder
            //
            this.cmbRasOrder.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            this.cmbRasOrder.DropDownWidth = 192;
            resources.ApplyResources( this.cmbRasOrder, "cmbRasOrder" );
            this.cmbRasOrder.Name = "cmbRasOrder";
            this.cmbRasOrder.SelectedItemData = null;
            //
            // labTexMapOrder
            //
            resources.ApplyResources( this.labTexMapOrder, "labTexMapOrder" );
            this.labTexMapOrder.Name = "labTexMapOrder";
            //
            // labRasOrder
            //
            resources.ApplyResources( this.labRasOrder, "labRasOrder" );
            this.labRasOrder.Name = "labRasOrder";
            //
            // ctlColorStage
            //
            resources.ApplyResources( this.ctlColorStage, "ctlColorStage" );
            this.ctlColorStage.Name = "ctlColorStage";
            //
            // ctlAlphaStage
            //
            resources.ApplyResources( this.ctlAlphaStage, "ctlAlphaStage" );
            this.ctlAlphaStage.Name = "ctlAlphaStage";
            //
            // ctlIndirectStage
            //
            this.ctlIndirectStage.BackColor = System.Drawing.SystemColors.ActiveBorder;
            tevIndirectStage1.AddPrev = false;
            tevIndirectStage1.AlphaSel = LECore.Structures.Nsrif.Attributes.AttrTevIndAlpha.ItbaOff;
            tevIndirectStage1.BiasSel = LECore.Structures.Nsrif.Attributes.AttrTevIndBias.ItbNone;
            tevIndirectStage1.Format = LECore.Structures.Nsrif.Attributes.AttrTevIndFormat.Itf8;
            tevIndirectStage1.IndStage = 0;
            tevIndirectStage1.MatrixSel = LECore.Structures.Nsrif.Attributes.AttrTevIndMatrix.ItmOff;
            tevIndirectStage1.UtcLod = false;
            tevIndirectStage1.WrapS = LECore.Structures.Nsrif.Attributes.AttrTevIndWrap.ItwOff;
            tevIndirectStage1.WrapT = LECore.Structures.Nsrif.Attributes.AttrTevIndWrap.ItwOff;
            this.ctlIndirectStage.Data = tevIndirectStage1;
            resources.ApplyResources( this.ctlIndirectStage, "ctlIndirectStage" );
            this.ctlIndirectStage.Name = "ctlIndirectStage";
            //
            // _grpIndirectStage
            //
            this._grpIndirectStage.Controls.Add( this.labIndirectStageLine );
            this._grpIndirectStage.Controls.Add( this.labIndirectStage );
            this._grpIndirectStage.Controls.Add( this.ctlIndirectStage );
            resources.ApplyResources( this._grpIndirectStage, "_grpIndirectStage" );
            this._grpIndirectStage.Name = "_grpIndirectStage";
            this._grpIndirectStage.TabStop = false;
            //
            // labIndirectStageLine
            //
            this.labIndirectStageLine.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            resources.ApplyResources( this.labIndirectStageLine, "labIndirectStageLine" );
            this.labIndirectStageLine.Name = "labIndirectStageLine";
            //
            // labIndirectStage
            //
            this.labIndirectStage.ForeColor = System.Drawing.Color.DarkRed;
            resources.ApplyResources( this.labIndirectStage, "labIndirectStage" );
            this.labIndirectStage.Name = "labIndirectStage";
            //
            // MaterialTevStagePage
            //
            this.Controls.Add( this._grpIndirectStage );
            this.Controls.Add( this.grpStage );
            this.Controls.Add( this.grpStageNo );
            this.Controls.Add( this.tbxNumStages );
            this.Controls.Add( this.labNumStages );
            resources.ApplyResources( this, "$this" );
            this.Name = "MaterialTevStagePage";
            this.grpStageNo.ResumeLayout( false );
            this.grpStage.ResumeLayout( false );
            this._grpIndirectStage.ResumeLayout( false );
            this.ResumeLayout( false );
            this.PerformLayout();

        }
        #endregion

        // ステージ選択ボタン管理
        private readonly UIRadioButton[] _stageButtons = new UIRadioButton[16];
        // ステージ番号
        private int _stageNo = 0;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public MaterialTevStagePage()
        {
            InitializeComponent();

            // ステージ選択ボタンを配列管理する
            _stageButtons[0]  = radStage0;
            _stageButtons[1]  = radStage1;
            _stageButtons[2]  = radStage2;
            _stageButtons[3]  = radStage3;
            _stageButtons[4]  = radStage4;
            _stageButtons[5]  = radStage5;
            _stageButtons[6]  = radStage6;
            _stageButtons[7]  = radStage7;
            _stageButtons[8]  = radStage8;
            _stageButtons[9]  = radStage9;
            _stageButtons[10] = radStage10;
            _stageButtons[11] = radStage11;
            _stageButtons[12] = radStage12;
            _stageButtons[13] = radStage13;
            _stageButtons[14] = radStage14;
            _stageButtons[15] = radStage15;
        }

        /// <summary>
        /// インスタンス作成。
        /// </summary>
        public static ObjPropertyPage CreateInstance(object arg)
        {
            ObjPropertyPage  page = new MaterialTevStagePage();
            MaterialTevStagePage stagePage = page as MaterialTevStagePage;

            return page;
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        public override PropertyPageID PageID
        {
            get { return PropertyPageID.MaterialTevStage; }
        }



        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void InitializeProperty()
        {
            // ステージ数
            tbxNumStages.ValueChanged += new EventHandler(Event_TbxNumStages_ValueChanged);

            // ステージ選択
            for (int i = 0; i < _stageButtons.Length; i++)
            {
                // On/Offが取りたいのでCheckedChangedOnは使用しない
                _stageButtons[i].Tag = i;
                _stageButtons[i].CheckedChanged += new EventHandler(Event_BtnStage_CheckedChanged);
            }

            // RasOrder
            cmbRasOrder.AddItem("PROP_MAT_TEV_STAGE_RASORDER_NULL", AttrRasOrder.ColorNull, true);
            cmbRasOrder.AddItem("PROP_MAT_TEV_STAGE_RASORDER_C0A0", AttrRasOrder.Color0A0, true);
            cmbRasOrder.SelectedIndexChanged += new EventHandler(Event_CmbRasOrder_SelectedIndexChanged);
            cmbRasOrder.DrawItem += new DrawItemEventHandler(Event_CmbRasOrder_DrawItem);

            // TexMapOrder
            cmbTexMapOrder.AddItem("PROP_MAT_TEV_STAGE_TEXORDER_NULL", -1, true);
            cmbTexMapOrder.AddItem("PROP_MAT_TEV_STAGE_TEXORDER_0",     0, true);
            cmbTexMapOrder.AddItem("PROP_MAT_TEV_STAGE_TEXORDER_1",     1, true);
            cmbTexMapOrder.AddItem("PROP_MAT_TEV_STAGE_TEXORDER_2",     2, true);
            cmbTexMapOrder.AddItem("PROP_MAT_TEV_STAGE_TEXORDER_3",     3, true);
            cmbTexMapOrder.AddItem("PROP_MAT_TEV_STAGE_TEXORDER_4",     4, true);
            cmbTexMapOrder.AddItem("PROP_MAT_TEV_STAGE_TEXORDER_5",     5, true);
            cmbTexMapOrder.AddItem("PROP_MAT_TEV_STAGE_TEXORDER_6",     6, true);
            cmbTexMapOrder.AddItem("PROP_MAT_TEV_STAGE_TEXORDER_7",     7, true);
            cmbTexMapOrder.SelectedIndexChanged += new EventHandler(Event_CmbTexMapOrder_SelectedIndexChanged);
            cmbTexMapOrder.DrawItem += new DrawItemEventHandler(Event_CmbTexMapOrder_DrawItem);

            // RasSwap
            cmbRasSwap.AddItem("PROP_MAT_TEV_STAGE_SWAP_0", 0, true);
            cmbRasSwap.AddItem("PROP_MAT_TEV_STAGE_SWAP_1", 1, true);
            cmbRasSwap.AddItem("PROP_MAT_TEV_STAGE_SWAP_2", 2, true);
            cmbRasSwap.AddItem("PROP_MAT_TEV_STAGE_SWAP_3", 3, true);
            cmbRasSwap.SelectedIndexChanged += new EventHandler(Event_CmbRasSwap_SelectedIndexChanged);
            cmbRasSwap.DrawItem += new DrawItemEventHandler(Event_CmbSwap_DrawItem);

            // TexMapSwap
            cmbTexMapSwap.AddItem("PROP_MAT_TEV_STAGE_SWAP_0", 0, true);
            cmbTexMapSwap.AddItem("PROP_MAT_TEV_STAGE_SWAP_1", 1, true);
            cmbTexMapSwap.AddItem("PROP_MAT_TEV_STAGE_SWAP_2", 2, true);
            cmbTexMapSwap.AddItem("PROP_MAT_TEV_STAGE_SWAP_3", 3, true);
            cmbTexMapSwap.SelectedIndexChanged += new EventHandler(Event_CmbTexMapSwap_SelectedIndexChanged);
            cmbTexMapSwap.DrawItem += new DrawItemEventHandler(Event_CmbSwap_DrawItem);



            // ステージ設定
            ctlColorStage.InitializeProperty();
            ctlAlphaStage.InitializeProperty();
            ctlIndirectStage.InitializeProperty();

            ctlColorStage.DataChanged    += new EventHandler(Event_CtlColorStage_DataChanged);
            ctlAlphaStage.DataChanged    += new EventHandler(Event_CtlAlphaStage_DataChanged);
            ctlIndirectStage.DataChanged += new EventHandler(Event_CtlIndirectStage_DataChanged);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void UpdateProperty()
        {
            TevStages stages = this.ActiveTarget.TevData.Stages;

            // ステージ番号調整
            if (_stageNo >= stages.NumStages)
            {
                _stageNo = 0;
            }

            //-----------------------------------------------------------------
            // ステージ選択
            //-----------------------------------------------------------------

            // ステージ数
            tbxNumStages.SetValue(stages.NumStages);

            // ステージ番号
            for (int i = 0; i < _stageButtons.Length; i++)
            {
                UIRadioButton button = _stageButtons[i];

                button.SetCheckedByTag(_stageNo);
                button.Enabled = i < stages.NumStages;

                if (i < stages.NumStages)
                {
                    button.Font = LayoutEditor.AppMain.GuiFontBold;
                    if (i == _stageNo) { button.ForeColor = Color.Red;                }
                    else               { button.ForeColor = SystemColors.ControlText; }
                }
                else
                {
                    button.Font      = this.Font;
                    button.ForeColor = SystemColors.ControlText;
                }

                //				if (i == _stageNo)
                //				{
                //					_stageButtons[i].Font      = TheApp.GuiFontBold;
                //					_stageButtons[i].ForeColor = Color.Red;
                //				}
                //				else
                //				{
                //					_stageButtons[i].Font      = this.Font;
                //					_stageButtons[i].ForeColor = SystemColors.ControlText;
                //				}
            }

            //-----------------------------------------------------------------
            // ステージ設定
            //-----------------------------------------------------------------

            TevStage stage = stages[_stageNo];

            // オーダー
            cmbRasOrder.SetSelectedItemData(stage.RasOrder);
            cmbTexMapOrder.SetSelectedItemData(stage.TexMapOrder);

            // スワップ
            cmbRasSwap.SetSelectedItemData(stage.RasSwap);
            cmbTexMapSwap.SetSelectedItemData(stage.TexMapSwap);

            // ステージ設定
            ctlColorStage.Data    = stage.ColorStage;
            ctlAlphaStage.Data    = stage.AlphaStage;
            ctlIndirectStage.Data = stage.IndirectStage;

            // 選択項目が変更されない場合でもサムネイルの描画が
            // 必要なので強制的に再描画させる
            cmbRasOrder.Invalidate();
            cmbRasSwap.Invalidate();
            cmbTexMapOrder.Invalidate();
            cmbTexMapSwap.Invalidate();
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region コピー＆ペースト
        /// <summary>
        /// コピーが可能か。
        /// </summary>
        public override bool CanCopy(){ return true; }

        /// <summary>
        /// コピー。
        /// </summary>
        public override Object Copy()
        {
            return Copy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public static Object Copy(MaterialGUIAdapter target)
        {
            return new TevStages(target.TevData.Stages);
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public override void Paste(Object pasteObject)
        {
            Paste(ActiveTarget, pasteObject);
            UpdateProperty();
            NotifyPropertyChanged();
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public static void Paste(MaterialGUIAdapter destination, Object pasteObject)
        {
            Debug.Assert(pasteObject is TevStages);
            TevStages source = (TevStages)pasteObject;
            destination.TevData.Stages.Set(source);

            // MCS
            //			MaterialTevStageCount.Send(destination, 0,
            //				destination.TevData.Stages.NumStages);
        }
        #endregion

        #region ターゲット取得ヘルパ
        /// <summary>
        /// ターゲットステージ。
        /// </summary>
        private TevStage TargetStage
        {
            get
            {
                Debug.Assert(_stageNo != -1);
                return this.ActiveTarget.TevData.Stages[_stageNo];
            }
        }
        #endregion

        #region イベントハンドラ
        // ステージ数
        private void Event_TbxNumStages_ValueChanged(object sender, EventArgs e)
        {
            int preNumStages = this.ActiveTarget.TevData.Stages.NumStages;
            int numStages = tbxNumStages.Value;

            this.ActiveTarget.TevData.Stages.NumStages = numStages;
            if (_stageNo >= numStages)
            {
                _stageNo = 0;
            }

            UpdateProperty();
            NotifyPropertyChanged();

            //			// MCS
            //			using(MCSFreezeBlock block = new MCSFreezeBlock())
            //			{
            //				MaterialTevStageCount.Send(ActiveTarget, preNumStages, numStages);
            //			}
            //			if(preNumStages < numStages){ MCSManager.WaitTransmission(); }
        }

        // ステージ選択
        private void Event_BtnStage_CheckedChanged(object sender, EventArgs e)
        {
            UIRadioButton button = (UIRadioButton)sender;

            if (button.Checked)
            {
                button.Font      = LayoutEditor.AppMain.GuiFontBold;
                button.ForeColor = Color.Red;

                // ステージ変更
                _stageNo = (int)button.Tag;
                UpdateProperty();
            }
            else
            {
                button.Font      = this.Font;
                button.ForeColor = SystemColors.ControlText;
            }
        }

        // カラーオーダー
        private void Event_CmbRasOrder_SelectedIndexChanged(object sender, EventArgs e)
        {
            TevStage stage = this.TargetStage;
            stage.RasOrder = (AttrRasOrder)cmbRasOrder.SelectedItemData;
            NotifyPropertyChanged();

            // MCS
            //			MaterialTevOrder.Send(ActiveTarget, _stageNo,
            //				stage.RasOrder, stage.TexMapOrder, stage.TexCoordOrder);
        }

        private void Event_CmbRasOrder_DrawItem(object sender, DrawItemEventArgs e)
        {
            // 背景
            e.DrawBackground();

            // e.Index は描画する項目番号
            // 選択項目が項目に存在しない場合は e.Index == -1 になるので描画しない
            if (e.Index >= 0)
            {
                UIListControlItem item     = (UIListControlItem)((ComboBox)sender).Items[e.Index];
                string            itemText = item.Text;
                AttrRasOrder      itemData = (AttrRasOrder)item.Data;

                // カラーレジスタ
                MaterialGUIAdapter      target   = this.ActiveTarget;
                ColorRegister register = null;
                MaterialColorShadingInfo	info	= new MaterialColorShadingInfo();
                bool		specular_enable	= true;
                switch (itemData)
                {
                    case AttrRasOrder.ColorNull:
                        break;
                    case AttrRasOrder.Color0A0:
                        register = target.ColorAssignData.Diffuse.GetTargetRegister(target);
                        info.Diffuse	= register.Color.ToColor();
                        info.Ambient	= target.ColorAssignData.Ambient.GetTargetRegister(target).Color.ToColor();
                        info.LightingDiffuse	= target.ChannelData.DiffuseCtrl.Lighting;
                        break;
                    case AttrRasOrder.Color1A1:
                        register = target.ColorAssignData.Specular.GetTargetRegister(target);
                        info.Diffuse	= Color.Black;
                        info.Specular	= register.Color.ToColor();
                        info.LightingSpecular	= target.ChannelData.SpecularCtrl.Lighting;
                        specular_enable	= info.LightingSpecular;
                        break;
                    default:
                        Debug.Assert(false);
                        break;
                }

                // カラー枠
            {
                Rectangle rect	= e.Bounds;
                rect.Inflate( -1, -1 );
                rect.Size	= new Size( rect.Height, rect.Height );
                if( register != null && specular_enable )
                {
                    Rectangle rcShader = rect;
                    rcShader.Inflate(-1, -1);
                    MaterialColorShader.DrawColor( e.Graphics, rcShader, info );
                    GraphicsUtil.DrawRectangle(e.Graphics, Pens.Black, rect);
                }
                else
                {
                    e.Graphics.DrawLine( Pens.Gray, rect.X, rect.Y, rect.Right-1, rect.Bottom-1 );
                    e.Graphics.DrawLine( Pens.Gray, rect.X, rect.Bottom-1, rect.Right-1, rect.Y );
                    GraphicsUtil.DrawRectangle(e.Graphics, Pens.Gray, rect);
                }
            }

                // テキスト
                using (StringFormat sf = new StringFormat())
                {
                    Rectangle rect	= new Rectangle( e.Bounds.X + e.Bounds.Height, e.Bounds.Y, e.Bounds.Width - e.Bounds.Height, e.Bounds.Height );
                    sf.Alignment     = StringAlignment.Near;
                    sf.LineAlignment = StringAlignment.Center;
                    sf.FormatFlags  |= StringFormatFlags.NoWrap;

                    Brush brush;
                    if( !specular_enable )						 { brush = Brushes.Gray;    }
                    else if ((e.State & DrawItemState.Selected) != 0) { brush = SystemBrushes.HighlightText; }
                    else                                         { brush = SystemBrushes.WindowText;    }

                    e.Graphics.DrawString(itemText, e.Font, brush, rect, sf);
                }
            }

            // フォーカス枠
            e.DrawFocusRectangle();
        }

        // テクスチャオーダー
        private void Event_CmbTexMapOrder_SelectedIndexChanged(object sender, EventArgs e)
        {
            int texMapOrder = (int)cmbTexMapOrder.SelectedItemData;

            // TexMapとTexCoordで同じオーダーを使用する
            TevStage stage = this.TargetStage;
            stage.TexMapOrder   = texMapOrder;
            stage.TexCoordOrder = texMapOrder;

            NotifyPropertyChanged();

            // MCS
            //			MaterialTevOrder.Send(ActiveTarget, _stageNo,
            //				stage.RasOrder, stage.TexMapOrder, stage.TexCoordOrder);
        }

        private void Event_CmbTexMapOrder_DrawItem(object sender, DrawItemEventArgs e)
        {
            e.DrawBackground();

            if (e.Index >= 0)
            {
                UIListControlItem item     = (UIListControlItem)((ComboBox)sender).Items[e.Index];
                string            itemText = item.Text;
                int               itemData = (int)item.Data;

                // テクスチャイメージ
                TexImage texImage = this.ActiveTarget.TexMapList.SearchTexImageByTexMapID(itemData);

                // 描画処理
            {
                Rectangle rect	= e.Bounds;
                rect.Inflate( -1, -1 );
                rect.Size	= new Size( rect.Height, rect.Height );
                if( texImage != null )
                {
                    texImage.DrawColorImage( e.Graphics, rect, true );
                    GraphicsUtil.DrawRectangle(e.Graphics, Pens.Black, rect);
                }
                else
                {
                    e.Graphics.DrawLine( Pens.Gray, rect.X, rect.Y, rect.Right-1, rect.Bottom-1 );
                    e.Graphics.DrawLine( Pens.Gray, rect.X, rect.Bottom-1, rect.Right-1, rect.Y );
                    GraphicsUtil.DrawRectangle(e.Graphics, Pens.Gray, rect);
                }
            }

                // テキスト
                using (StringFormat sf = new StringFormat())
                {
                    Rectangle rect = new Rectangle( e.Bounds.X + e.Bounds.Height, e.Bounds.Y, e.Bounds.Width - e.Bounds.Height, e.Bounds.Height );
                    sf.Alignment     = StringAlignment.Near;
                    sf.LineAlignment = StringAlignment.Center;
                    sf.Trimming      = StringTrimming.EllipsisCharacter;
                    sf.FormatFlags  |= StringFormatFlags.NoWrap;

                    Brush brush;
                    if      (texImage == null && e.Index > 0)         { brush = Brushes.Gray;                }
                    else if ((e.State & DrawItemState.Selected) != 0) { brush = SystemBrushes.HighlightText; }
                    else                                              { brush = SystemBrushes.WindowText;    }

                    if( texImage != null )
                    {
                        itemText += " (";
                        itemText += texImage.Texture.Name;
                        itemText += ")";
                    }
                    e.Graphics.DrawString(itemText, e.Font, brush, rect, sf);
                }
            }

            e.DrawFocusRectangle();
        }

        // スワップ選択
        private void Event_CmbRasSwap_SelectedIndexChanged(object sender, EventArgs e)
        {
            this.TargetStage.RasSwap = (int)cmbRasSwap.SelectedItemData;
            NotifyPropertyChanged();

            // MCS
            //			MaterialTevSwap.Send(ActiveTarget, _stageNo,
            //				TargetStage.RasSwap, TargetStage.TexMapSwap);
        }

        private void Event_CmbTexMapSwap_SelectedIndexChanged(object sender, EventArgs e)
        {
            this.TargetStage.TexMapSwap = (int)cmbTexMapSwap.SelectedItemData;
            NotifyPropertyChanged();

            // MCS
            //			MaterialTevSwap.Send(ActiveTarget, _stageNo,
            //				TargetStage.RasSwap, TargetStage.TexMapSwap);
        }

        private Color	GetSwapTableColor( AttrSwapArg arg )
        {
            switch( arg )
            {
                case AttrSwapArg.R:	return Color.Red;
                case AttrSwapArg.G:	return Color.Green;
                case AttrSwapArg.B:	return Color.Blue;
                case AttrSwapArg.A:	return Color.White;
                default:	Debug.Assert(false);	return Color.White;
            }
        }

        private string	GetSwapTableString( AttrSwapArg arg )
        {
            switch( arg )
            {
                case AttrSwapArg.R:	return "R";
                case AttrSwapArg.G:	return "G";
                case AttrSwapArg.B:	return "B";
                case AttrSwapArg.A:	return "A";
                default:	Debug.Assert(false);	return "";
            }
        }

        private void Event_CmbSwap_DrawItem(object sender, DrawItemEventArgs e)
        {
            e.DrawBackground();

            if (e.Index >= 0)
            {
                UIListControlItem item     = (UIListControlItem)((ComboBox)sender).Items[e.Index];
                string            itemText = item.Text;
                int               itemData = (int)item.Data;

                // スワップテーブル
                TevSwapTable swapTable = this.ActiveTarget.TevData.SwapTables[itemData];

                // 描画処理
                using (StringFormat sf = new StringFormat())
                {
                    sf.Alignment     = StringAlignment.Center;
                    sf.LineAlignment = StringAlignment.Center;
                    Rectangle	rect	= e.Bounds;
                    rect.Inflate( -1, -1 );
                    rect.Size	= new Size( rect.Height, rect.Height );
                    Rectangle	rect2	= rect;
                    rect2.Size	= new Size( rect2.Width/2, rect2.Height/2 );
                    using( SolidBrush brush = new SolidBrush(GetSwapTableColor(swapTable.R)))
                    {
                        e.Graphics.FillRectangle( brush, rect2 );
                        e.Graphics.DrawString(GetSwapTableString(swapTable.R), e.Font,
                            (swapTable.R != AttrSwapArg.A)?Brushes.White:Brushes.Black, rect2, sf);
                    }
                    rect2.Offset( rect2.Width, 0 );
                    using( SolidBrush brush = new SolidBrush(GetSwapTableColor(swapTable.G)))
                    {
                        e.Graphics.FillRectangle( brush, rect2 );
                        e.Graphics.DrawString(GetSwapTableString(swapTable.G), e.Font,
                            (swapTable.G != AttrSwapArg.A)?Brushes.White:Brushes.Black, rect2, sf);
                    }
                    rect2.Offset( 0, rect2.Height );
                    using( SolidBrush brush = new SolidBrush(GetSwapTableColor(swapTable.A)))
                    {
                        e.Graphics.FillRectangle( brush, rect2 );
                        e.Graphics.DrawString(GetSwapTableString(swapTable.A), e.Font,
                            (swapTable.A != AttrSwapArg.A)?Brushes.White:Brushes.Black, rect2, sf);
                    }
                    rect2.Offset( -rect2.Width, 0 );
                    using( SolidBrush brush = new SolidBrush(GetSwapTableColor(swapTable.B)))
                    {
                        e.Graphics.FillRectangle( brush, rect2 );
                        e.Graphics.DrawString(GetSwapTableString(swapTable.B), e.Font,
                            (swapTable.B != AttrSwapArg.A)?Brushes.White:Brushes.Black, rect2, sf);
                    }
                    e.Graphics.DrawLine( Pens.Black, rect2.Right-1, rect.Y, rect2.Right-1, rect.Bottom-1 );
                    e.Graphics.DrawLine( Pens.Black, rect.X, rect2.Top-1, rect.Right-1, rect2.Top-1 );
                    App.Utility.GraphicsUtil.DrawRectangle(e.Graphics, Pens.Black, rect);
                }

                // テキスト
                using (StringFormat sf = new StringFormat())
                {
                    Rectangle rect	= new Rectangle( e.Bounds.X + e.Bounds.Height, e.Bounds.Y, e.Bounds.Width - e.Bounds.Height, e.Bounds.Height );
                    sf.Alignment     = StringAlignment.Near;
                    sf.LineAlignment = StringAlignment.Center;
                    sf.FormatFlags  |= StringFormatFlags.NoWrap;

                    Brush brush;
                    if ((e.State & DrawItemState.Selected) != 0) { brush = SystemBrushes.HighlightText; }
                    else                                         { brush = SystemBrushes.WindowText;    }

                    e.Graphics.DrawString(itemText, e.Font, brush, rect, sf);
                }
            }

            e.DrawFocusRectangle();
        }

        // カラーステージ
        private void Event_CtlColorStage_DataChanged(object sender, EventArgs e)
        {
            LECore.DbgConsole.WriteLine("ColorStage_DataChanged");
            LECore.DbgConsole.WriteLine(ctlColorStage.Data.ToString());

            this.TargetStage.ColorStage.Set(ctlColorStage.Data);
            NotifyPropertyChanged();

            // MCS
            //			MaterialColorStage.Send(ActiveTarget, _stageNo,
            //				TargetStage.ColorStage);
        }

        // アルファステージ
        private void Event_CtlAlphaStage_DataChanged(object sender, EventArgs e)
        {
            LECore.DbgConsole.WriteLine("AlphaStage_DataChanged");
            LECore.DbgConsole.WriteLine(ctlAlphaStage.Data.ToString());

            this.TargetStage.AlphaStage.Set(ctlAlphaStage.Data);
            NotifyPropertyChanged();

            // MCS
            //			MaterialAlphaStage.Send(ActiveTarget, _stageNo,
            //				TargetStage.AlphaStage);
        }



        // インダイレクトステージ
        private void Event_CtlIndirectStage_DataChanged(object sender, EventArgs e)
        {
            LECore.DbgConsole.WriteLine("IndirectStage_DataChanged");
            LECore.DbgConsole.WriteLine(ctlIndirectStage.Data.ToString());

            this.TargetStage.IndirectStage.Set(ctlIndirectStage.Data);
            NotifyPropertyChanged();
        }
        #endregion


    }
}

