﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

using LayoutEditor.Controls;
using LayoutEditor.Utility;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.TextureControls
{
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters ;
    using LECore.Structures;
    /// <summary>
    /// テクスチャ追加ダイアログクラス。
    /// </summary>
    public sealed class TextureAddDialog : Form
    {
        #region デザイナ変数

        private System.Windows.Forms.Button btnOK;
        private System.Windows.Forms.Button btnCancel;
        private System.Windows.Forms.Panel pnlTop;
        private System.Windows.Forms.Label labTitle;
        private System.Windows.Forms.Label labTop;
        private System.Windows.Forms.Panel pnlPage;
        private System.Windows.Forms.Label labBottomBorder;
        private System.Windows.Forms.Button btnNext;
        private System.Windows.Forms.Button btnPrev;
        private System.ComponentModel.Container components = null;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
      System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(TextureAddDialog));
      this.btnOK = new System.Windows.Forms.Button();
      this.btnCancel = new System.Windows.Forms.Button();
      this.labTitle = new System.Windows.Forms.Label();
      this.pnlTop = new System.Windows.Forms.Panel();
      this.labTop = new System.Windows.Forms.Label();
      this.btnNext = new System.Windows.Forms.Button();
      this.btnPrev = new System.Windows.Forms.Button();
      this.pnlPage = new System.Windows.Forms.Panel();
      this.labBottomBorder = new System.Windows.Forms.Label();
      this.pnlTop.SuspendLayout();
      this.SuspendLayout();
      //
      // btnOK
      //
      resources.ApplyResources(this.btnOK, "btnOK");
      this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
      this.btnOK.Name = "btnOK";
      //
      // btnCancel
      //
      resources.ApplyResources(this.btnCancel, "btnCancel");
      this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
      this.btnCancel.Name = "btnCancel";
      //
      // labTitle
      //
      resources.ApplyResources(this.labTitle, "labTitle");
      this.labTitle.Name = "labTitle";
      //
      // pnlTop
      //
      this.pnlTop.BackColor = System.Drawing.Color.White;
      this.pnlTop.Controls.Add(this.labTitle);
      this.pnlTop.Controls.Add(this.labTop);
      resources.ApplyResources(this.pnlTop, "pnlTop");
      this.pnlTop.Name = "pnlTop";
      //
      // labTop
      //
      this.labTop.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
      resources.ApplyResources(this.labTop, "labTop");
      this.labTop.Name = "labTop";
      //
      // btnNext
      //
      resources.ApplyResources(this.btnNext, "btnNext");
      this.btnNext.Name = "btnNext";
      //
      // btnPrev
      //
      resources.ApplyResources(this.btnPrev, "btnPrev");
      this.btnPrev.Name = "btnPrev";
      //
      // pnlPage
      //
      resources.ApplyResources(this.pnlPage, "pnlPage");
      this.pnlPage.Name = "pnlPage";
      //
      // labBottomBorder
      //
      resources.ApplyResources(this.labBottomBorder, "labBottomBorder");
      this.labBottomBorder.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
      this.labBottomBorder.Name = "labBottomBorder";
      //
      // TextureAddDialog
      //
      resources.ApplyResources(this, "$this");
      this.CancelButton = this.btnCancel;
      this.Controls.Add(this.pnlPage);
      this.Controls.Add(this.pnlTop);
      this.Controls.Add(this.btnPrev);
      this.Controls.Add(this.btnNext);
      this.Controls.Add(this.btnOK);
      this.Controls.Add(this.btnCancel);
      this.Controls.Add(this.labBottomBorder);
      this.MaximizeBox = false;
      this.MinimizeBox = false;
      this.Name = "TextureAddDialog";
      this.ShowInTaskbar = false;
      this.pnlTop.ResumeLayout(false);
      this.pnlTop.PerformLayout();
      this.ResumeLayout(false);

        }
        #endregion

      private readonly TextureAddDataPage _dataPage;
      private readonly UserControl[]      _pages = new UserControl[2];
#if false
      private readonly TextureAddTypePage _typePage;
      private Mode                        _mode  = Mode.Type;
#else
      private Mode                        _mode  = Mode.Data;
#endif

      // モード
      private enum Mode
      {
#if false
          Type = 0, // タイプ選択
          Data = 1, // データ選択
#else
          Data = 0, // データ選択
#endif
      }

      /// <summary>
      /// コンストラクタ。
      /// </summary>
      public TextureAddDialog(MaterialGUIAdapter material, bool selfCaptureTextureEnabled)
      {
          InitializeComponent();

          // アイコン
          // this.Icon = TheApp.LayoutWindow.Icon;

          // イベント登録
          btnPrev.Click += new EventHandler(Event_BtnPrev_Click);
          btnNext.Click += new EventHandler(Event_BtnNext_Click);

            // ページ作成
#if false
          _typePage = new TextureAddTypePage(material);
          _typePage.Parent = pnlPage;
          _typePage.Dock = DockStyle.Fill;
          _typePage.Visible = true;
#endif
          IPane dynamicCapturePane = null;
          if (selfCaptureTextureEnabled &&
              material.IMaterial.OwnerPane != null && material.IMaterial.OwnerPane.OwnerSubScene.IPartsLayout == null)
          {
              dynamicCapturePane = material.IMaterial.OwnerPane;
          }

          _dataPage = new TextureAddDataPage(dynamicCapturePane);
          _dataPage.Parent = pnlPage;
          _dataPage.Dock = DockStyle.Fill;
          _dataPage.Visible = true;

#if false
          _pages[0] = _typePage;
          _pages[1] = _dataPage;
#else
          _pages[0] = _dataPage;
#endif

          UpdateComponent();
      }

      /// <summary>
      /// 座標生成方法。
      /// </summary>
      public LETexGenMethod Method
      {
#if false
          get { return _typePage.Method; }
#else
          get { return LETexGenMethod.UV0; }
#endif
      }

      /// <summary>
      /// テクスチャ種類
      /// </summary>
      public TexMapKind Kind
      {
#if false
          get { return _typePage.Kind; }
#else
          get { return TexMapKind.Normal; }
#endif
      }

        /// <summary>
        /// テクスチャ。
        /// </summary>
        public Texture Texture
        {
            get { return _dataPage.Texture; }
        }

#if false
        /// <summary>
        /// パレット。
        /// </summary>
        public Palette Palette
        {
            get { return _dataPage.Palette; }
        }
#endif

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        /// <summary>
        /// ページ変更。
        /// </summary>
        private void ChangePage(Mode mode)
        {
            // 次のページを表示（＆フォーカス設定）
            _pages[(int)mode].Visible = true;
            _pages[(int)mode].Focus();

            // 前のページを非表示
            _pages[(int)_mode].Visible = false;
            _mode = mode;

            // コンポーネント更新
            UpdateComponent();
        }

        /// <summary>
        /// コンポーネント更新。
        /// </summary>
        private void UpdateComponent()
        {
            // タイトル
            switch (_mode)
            {
#if false
      case Mode.Type: labTitle.Text = StringResMgr.Get("DLG_TEXTUREADD_TYPE_TITLE"); break;
#endif
            case Mode.Data: labTitle.Text = StringResMgr.Get("DLG_TEXTUREADD_DATA_TITLE"); break;
            default: break;
            }

            // ボタン
            int modeSize = Enum.GetValues(typeof(Mode)).Length;
            btnPrev.Enabled = (int)_mode >  0;
            btnNext.Enabled = (int)_mode <  modeSize - 1;
            btnOK.Enabled   = (int)_mode == modeSize - 1;

            // 既定のボタン
            if (_mode == Mode.Data) { this.AcceptButton = btnOK;   }
            else                    { this.AcceptButton = btnNext; }
        }

        /// <summary>
        /// イベントハンドラ。
        /// </summary>
        private void Event_BtnNext_Click(object sender, EventArgs e)
        {
            ChangePage((Mode)(_mode + 1));
        }

        /// <summary>
        /// イベントハンドラ。
        /// </summary>
        private void Event_BtnPrev_Click(object sender, EventArgs e)
        {
            ChangePage((Mode)(_mode - 1));
        }
    }
}
