﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Windows.Forms;
using System.Runtime.InteropServices;

using LayoutEditor.Controls;
using LayoutEditor.Utility;
using LayoutEditor.src.Forms.ToolWindows.PropertyEditWindow.Material;

using LECore;
using LECore.Structures;
using LECore.Structures.LECoreInterface;
using LECore.Structures.Nsrif.Attributes;
using LECore.Structures.Nsrif.Elements;


namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    using App = LayoutEditor;
    using MatPage = LayoutEditor.Forms.ToolWindows.PropertyEditWindow;
    using TexCtrls = LayoutEditor.Forms.ToolWindows.PropertyEditWindow.TextureControls;

    using Adapters;
    using TextureControls;
    using LECore.Manipulator;
    using LECore.Structures.Core;
    using System.Collections.Generic;

    /// <summary>
    /// マテリアルテクスチャページクラス。
    /// </summary>
    public sealed class MaterialTexturePage : MaterialPage
    {
        #region デザイナ変数

        private TexCtrls.TexMapBox ctlTexMap0;
        private TexCtrls.TexMapBox ctlTexMap1;
        private TexCtrls.TexMapBox ctlTexMap2;
        private TexCtrls.TexMapBox ctlTexMap3;
        private TexCtrls.TexMapBox ctlTexMap4;
        private TexCtrls.TexMapBox ctlTexMap5;
        private TexCtrls.TexMapBox ctlTexMap6;
        private TexCtrls.TexMapBox ctlTexMap7;
        private System.Windows.Forms.TabControl tabSetting;
        private System.Windows.Forms.TabPage tpgImage;
        private System.Windows.Forms.TabPage tpgMapping;
        private System.Windows.Forms.GroupBox grpImgFilter;
        private System.Windows.Forms.Panel pnlImgFilterMin;
        private System.Windows.Forms.Panel pnlImgFilterMag;
        private System.Windows.Forms.GroupBox grpImgWrap;
        private System.Windows.Forms.Panel pnlImgWrapS;
        private App.Controls.UIRadioButton radImgWrapSClamp;
        private App.Controls.UIRadioButton radImgWrapSRepeat;
        private App.Controls.UIRadioButton radImgWrapSMirror;
        private System.Windows.Forms.Panel pnlImgWrapT;
        private App.Controls.UIRadioButton radImgWrapTClamp;
        private App.Controls.UIRadioButton radImgWrapTRepeat;
        private App.Controls.UIRadioButton radImgWrapTMirror;
        private App.Controls.UIRadioButton radImgFilterMinN;
        private App.Controls.UIRadioButton radImgFilterMinL;
        private App.Controls.UIRadioButton radImgFilterMagN;
        private App.Controls.UIRadioButton radImgFilterMagL;
        private System.Windows.Forms.Button btnTexMapAdd;
        private System.Windows.Forms.Button btnTexMapRemove;
        private App.Controls.UIComboBox cmbMapMethod;
        private System.Windows.Forms.Button btnTexMapMoveLeft;
        private System.Windows.Forms.Button btnTexMapMoveRight;
        private LayoutEditor.Controls.DockContentToolTip ttpHint;
        private App.Controls.ThumbnailBox ctlAttrAlpha;
        private App.Controls.ThumbnailBox ctlAttrColor;
        private System.Windows.Forms.Button btnAttrChangeImage;
        private System.Windows.Forms.Panel pnlAttr;
        private System.Windows.Forms.Label lblTexMap7;
        private System.Windows.Forms.Label lblTexMap6;
        private System.Windows.Forms.Label lblTexMap5;
        private System.Windows.Forms.Label lblTexMap4;
        private System.Windows.Forms.Label lblTexMap3;
        private System.Windows.Forms.Label lblTexMap2;
        private System.Windows.Forms.Label lblTexMap1;
        private System.Windows.Forms.Label lblTexMap0;
        private System.Windows.Forms.GroupBox grpTexMap;
        private System.Windows.Forms.Label lblAttrAlpha;
        private System.Windows.Forms.Label lblAttrColor;
        private System.Windows.Forms.Label lblAttrName;
        private System.Windows.Forms.Label lblAttrSize;
        private System.Windows.Forms.Label lblAttrSizeT;
        private System.Windows.Forms.Label lblAttrFormat;
        private System.Windows.Forms.Label lblAttrFormatT;
        private System.Windows.Forms.Label lblImgFilterMin;
        private System.Windows.Forms.Label lblImgFilterMag;
        private System.Windows.Forms.Label lblImgWrapS;
        private System.Windows.Forms.Label lblImgWrapT;
        private System.Windows.Forms.Label lblMapMethod;
        private System.Windows.Forms.GroupBox grpSelected;
        private LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Material.Texture.TexturePatternAnimAddPanel _ctlTexturePatternAnim;
        private System.Windows.Forms.TabPage tpgTexPatternAnim;
        private GroupBox _grpSrtMtx;
        private TextureSRTMtxEditPanel _pnlTextureMtx;
        private GroupBox _grpProjectionMapping;
        private Label _lblProjectionTrans;
        private Fvec2EditUpDownPanel _fudProjectionTrans;
        private Label _lblProjectionScale;
        private Fvec2EditUpDownPanel _fudProjectionScale;
        private UICheckBox _chkAutoScale;
        private Label _lblMappingNotice;
        private Panel pnlMapping;
        private Label _lblAutoScaleNote;
        private Label _lblMessageProjection;
        private UICheckBox _chkAdjustProjectionPaneSR;
        private UICheckBox _chkAutoScalePaneSize;
        private Label _lblAdjustPaneSRNote;
        private Button btnAddMovieTexture;
        private System.ComponentModel.IContainer components;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(MaterialTexturePage));
            this.ttpHint = new LayoutEditor.Controls.DockContentToolTip(this.components);
            this.btnTexMapMoveLeft = new System.Windows.Forms.Button();
            this.btnTexMapMoveRight = new System.Windows.Forms.Button();
            this._lblAutoScaleNote = new System.Windows.Forms.Label();
            this._lblMessageProjection = new System.Windows.Forms.Label();
            this._lblAdjustPaneSRNote = new System.Windows.Forms.Label();
            this.grpSelected = new System.Windows.Forms.GroupBox();
            this.pnlAttr = new System.Windows.Forms.Panel();
            this.lblAttrName = new System.Windows.Forms.Label();
            this.lblAttrSize = new System.Windows.Forms.Label();
            this.lblAttrSizeT = new System.Windows.Forms.Label();
            this.lblAttrFormat = new System.Windows.Forms.Label();
            this.lblAttrFormatT = new System.Windows.Forms.Label();
            this.lblAttrColor = new System.Windows.Forms.Label();
            this.ctlAttrColor = new LayoutEditor.Controls.ThumbnailBox();
            this.ctlAttrAlpha = new LayoutEditor.Controls.ThumbnailBox();
            this.lblAttrAlpha = new System.Windows.Forms.Label();
            this.tabSetting = new System.Windows.Forms.TabControl();
            this.tpgImage = new System.Windows.Forms.TabPage();
            this.grpImgFilter = new System.Windows.Forms.GroupBox();
            this.pnlImgFilterMin = new System.Windows.Forms.Panel();
            this.lblImgFilterMin = new System.Windows.Forms.Label();
            this.radImgFilterMinN = new LayoutEditor.Controls.UIRadioButton();
            this.radImgFilterMinL = new LayoutEditor.Controls.UIRadioButton();
            this.pnlImgFilterMag = new System.Windows.Forms.Panel();
            this.lblImgFilterMag = new System.Windows.Forms.Label();
            this.radImgFilterMagN = new LayoutEditor.Controls.UIRadioButton();
            this.radImgFilterMagL = new LayoutEditor.Controls.UIRadioButton();
            this.grpImgWrap = new System.Windows.Forms.GroupBox();
            this.pnlImgWrapS = new System.Windows.Forms.Panel();
            this.lblImgWrapS = new System.Windows.Forms.Label();
            this.radImgWrapSClamp = new LayoutEditor.Controls.UIRadioButton();
            this.radImgWrapSRepeat = new LayoutEditor.Controls.UIRadioButton();
            this.radImgWrapSMirror = new LayoutEditor.Controls.UIRadioButton();
            this.pnlImgWrapT = new System.Windows.Forms.Panel();
            this.lblImgWrapT = new System.Windows.Forms.Label();
            this.radImgWrapTClamp = new LayoutEditor.Controls.UIRadioButton();
            this.radImgWrapTRepeat = new LayoutEditor.Controls.UIRadioButton();
            this.radImgWrapTMirror = new LayoutEditor.Controls.UIRadioButton();
            this.tpgMapping = new System.Windows.Forms.TabPage();
            this.pnlMapping = new System.Windows.Forms.Panel();
            this.cmbMapMethod = new LayoutEditor.Controls.UIComboBox();
            this.lblMapMethod = new System.Windows.Forms.Label();
            this._grpSrtMtx = new System.Windows.Forms.GroupBox();
            this._pnlTextureMtx = new LayoutEditor.Forms.ToolWindows.PropertyEditWindow.TextureControls.TextureSRTMtxEditPanel();
            this._grpProjectionMapping = new System.Windows.Forms.GroupBox();
            this._chkAdjustProjectionPaneSR = new LayoutEditor.Controls.UICheckBox();
            this._chkAutoScalePaneSize = new LayoutEditor.Controls.UICheckBox();
            this._chkAutoScale = new LayoutEditor.Controls.UICheckBox();
            this._lblProjectionTrans = new System.Windows.Forms.Label();
            this._fudProjectionTrans = new LayoutEditor.Controls.Fvec2EditUpDownPanel();
            this._lblProjectionScale = new System.Windows.Forms.Label();
            this._fudProjectionScale = new LayoutEditor.Controls.Fvec2EditUpDownPanel();
            this._lblMappingNotice = new System.Windows.Forms.Label();
            this.tpgTexPatternAnim = new System.Windows.Forms.TabPage();
            this._ctlTexturePatternAnim = new LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Material.Texture.TexturePatternAnimAddPanel();
            this.grpTexMap = new System.Windows.Forms.GroupBox();
            this.btnAddMovieTexture = new System.Windows.Forms.Button();
            this.btnAttrChangeImage = new System.Windows.Forms.Button();
            this.btnTexMapAdd = new System.Windows.Forms.Button();
            this.btnTexMapRemove = new System.Windows.Forms.Button();
            this.ctlTexMap3 = new LayoutEditor.Forms.ToolWindows.PropertyEditWindow.TextureControls.TexMapBox();
            this.ctlTexMap0 = new LayoutEditor.Forms.ToolWindows.PropertyEditWindow.TextureControls.TexMapBox();
            this.ctlTexMap1 = new LayoutEditor.Forms.ToolWindows.PropertyEditWindow.TextureControls.TexMapBox();
            this.ctlTexMap2 = new LayoutEditor.Forms.ToolWindows.PropertyEditWindow.TextureControls.TexMapBox();
            this.ctlTexMap4 = new LayoutEditor.Forms.ToolWindows.PropertyEditWindow.TextureControls.TexMapBox();
            this.ctlTexMap5 = new LayoutEditor.Forms.ToolWindows.PropertyEditWindow.TextureControls.TexMapBox();
            this.ctlTexMap6 = new LayoutEditor.Forms.ToolWindows.PropertyEditWindow.TextureControls.TexMapBox();
            this.ctlTexMap7 = new LayoutEditor.Forms.ToolWindows.PropertyEditWindow.TextureControls.TexMapBox();
            this.lblTexMap7 = new System.Windows.Forms.Label();
            this.lblTexMap6 = new System.Windows.Forms.Label();
            this.lblTexMap5 = new System.Windows.Forms.Label();
            this.lblTexMap4 = new System.Windows.Forms.Label();
            this.lblTexMap3 = new System.Windows.Forms.Label();
            this.lblTexMap2 = new System.Windows.Forms.Label();
            this.lblTexMap1 = new System.Windows.Forms.Label();
            this.lblTexMap0 = new System.Windows.Forms.Label();
            this.grpSelected.SuspendLayout();
            this.pnlAttr.SuspendLayout();
            this.tabSetting.SuspendLayout();
            this.tpgImage.SuspendLayout();
            this.grpImgFilter.SuspendLayout();
            this.pnlImgFilterMin.SuspendLayout();
            this.pnlImgFilterMag.SuspendLayout();
            this.grpImgWrap.SuspendLayout();
            this.pnlImgWrapS.SuspendLayout();
            this.pnlImgWrapT.SuspendLayout();
            this.tpgMapping.SuspendLayout();
            this.pnlMapping.SuspendLayout();
            this._grpSrtMtx.SuspendLayout();
            this._grpProjectionMapping.SuspendLayout();
            this.tpgTexPatternAnim.SuspendLayout();
            this.grpTexMap.SuspendLayout();
            this.SuspendLayout();
            //
            // btnTexMapMoveLeft
            //
            resources.ApplyResources(this.btnTexMapMoveLeft, "btnTexMapMoveLeft");
            this.btnTexMapMoveLeft.Name = "btnTexMapMoveLeft";
            this.ttpHint.SetToolTip(this.btnTexMapMoveLeft, resources.GetString("btnTexMapMoveLeft.ToolTip"));
            //
            // btnTexMapMoveRight
            //
            resources.ApplyResources(this.btnTexMapMoveRight, "btnTexMapMoveRight");
            this.btnTexMapMoveRight.Name = "btnTexMapMoveRight";
            this.ttpHint.SetToolTip(this.btnTexMapMoveRight, resources.GetString("btnTexMapMoveRight.ToolTip"));
            //
            // _lblAutoScaleNote
            //
            this._lblAutoScaleNote.BackColor = System.Drawing.SystemColors.Control;
            resources.ApplyResources(this._lblAutoScaleNote, "_lblAutoScaleNote");
            this._lblAutoScaleNote.Name = "_lblAutoScaleNote";
            this.ttpHint.SetToolTip(this._lblAutoScaleNote, resources.GetString("_lblAutoScaleNote.ToolTip"));
            //
            // _lblMessageProjection
            //
            this._lblMessageProjection.BackColor = System.Drawing.SystemColors.Control;
            resources.ApplyResources(this._lblMessageProjection, "_lblMessageProjection");
            this._lblMessageProjection.Name = "_lblMessageProjection";
            this.ttpHint.SetToolTip(this._lblMessageProjection, resources.GetString("_lblMessageProjection.ToolTip"));
            //
            // _lblAdjustPaneSRNote
            //
            this._lblAdjustPaneSRNote.BackColor = System.Drawing.SystemColors.Control;
            resources.ApplyResources(this._lblAdjustPaneSRNote, "_lblAdjustPaneSRNote");
            this._lblAdjustPaneSRNote.Name = "_lblAdjustPaneSRNote";
            this.ttpHint.SetToolTip(this._lblAdjustPaneSRNote, resources.GetString("_lblAdjustPaneSRNote.ToolTip"));
            //
            // grpSelected
            //
            resources.ApplyResources(this.grpSelected, "grpSelected");
            this.grpSelected.Controls.Add(this.pnlAttr);
            this.grpSelected.Controls.Add(this.tabSetting);
            this.grpSelected.FlatStyle = System.Windows.Forms.FlatStyle.System;
            this.grpSelected.Name = "grpSelected";
            this.grpSelected.TabStop = false;
            //
            // pnlAttr
            //
            resources.ApplyResources(this.pnlAttr, "pnlAttr");
            this.pnlAttr.Controls.Add(this.lblAttrName);
            this.pnlAttr.Controls.Add(this.lblAttrSize);
            this.pnlAttr.Controls.Add(this.lblAttrSizeT);
            this.pnlAttr.Controls.Add(this.lblAttrFormat);
            this.pnlAttr.Controls.Add(this.lblAttrFormatT);
            this.pnlAttr.Controls.Add(this.lblAttrColor);
            this.pnlAttr.Controls.Add(this.ctlAttrColor);
            this.pnlAttr.Controls.Add(this.ctlAttrAlpha);
            this.pnlAttr.Controls.Add(this.lblAttrAlpha);
            this.pnlAttr.Name = "pnlAttr";
            //
            // lblAttrName
            //
            resources.ApplyResources(this.lblAttrName, "lblAttrName");
            this.lblAttrName.BackColor = System.Drawing.SystemColors.Window;
            this.lblAttrName.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblAttrName.Name = "lblAttrName";
            //
            // lblAttrSize
            //
            resources.ApplyResources(this.lblAttrSize, "lblAttrSize");
            this.lblAttrSize.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblAttrSize.Name = "lblAttrSize";
            //
            // lblAttrSizeT
            //
            resources.ApplyResources(this.lblAttrSizeT, "lblAttrSizeT");
            this.lblAttrSizeT.Name = "lblAttrSizeT";
            //
            // lblAttrFormat
            //
            resources.ApplyResources(this.lblAttrFormat, "lblAttrFormat");
            this.lblAttrFormat.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.lblAttrFormat.Name = "lblAttrFormat";
            //
            // lblAttrFormatT
            //
            resources.ApplyResources(this.lblAttrFormatT, "lblAttrFormatT");
            this.lblAttrFormatT.Name = "lblAttrFormatT";
            //
            // lblAttrColor
            //
            resources.ApplyResources(this.lblAttrColor, "lblAttrColor");
            this.lblAttrColor.Name = "lblAttrColor";
            //
            // ctlAttrColor
            //
            resources.ApplyResources(this.ctlAttrColor, "ctlAttrColor");
            this.ctlAttrColor.Name = "ctlAttrColor";
            //
            // ctlAttrAlpha
            //
            this.ctlAttrAlpha.ImageMode = LayoutEditor.Controls.ThumbnailBoxImageMode.Alpha;
            resources.ApplyResources(this.ctlAttrAlpha, "ctlAttrAlpha");
            this.ctlAttrAlpha.Name = "ctlAttrAlpha";
            //
            // lblAttrAlpha
            //
            resources.ApplyResources(this.lblAttrAlpha, "lblAttrAlpha");
            this.lblAttrAlpha.Name = "lblAttrAlpha";
            //
            // tabSetting
            //
            resources.ApplyResources(this.tabSetting, "tabSetting");
            this.tabSetting.Controls.Add(this.tpgImage);
            this.tabSetting.Controls.Add(this.tpgMapping);
            this.tabSetting.Controls.Add(this.tpgTexPatternAnim);
            this.tabSetting.Name = "tabSetting";
            this.tabSetting.SelectedIndex = 0;
            //
            // tpgImage
            //
            this.tpgImage.BackColor = System.Drawing.SystemColors.Control;
            this.tpgImage.Controls.Add(this.grpImgFilter);
            this.tpgImage.Controls.Add(this.grpImgWrap);
            resources.ApplyResources(this.tpgImage, "tpgImage");
            this.tpgImage.Name = "tpgImage";
            //
            // grpImgFilter
            //
            this.grpImgFilter.Controls.Add(this.pnlImgFilterMin);
            this.grpImgFilter.Controls.Add(this.pnlImgFilterMag);
            resources.ApplyResources(this.grpImgFilter, "grpImgFilter");
            this.grpImgFilter.Name = "grpImgFilter";
            this.grpImgFilter.TabStop = false;
            //
            // pnlImgFilterMin
            //
            this.pnlImgFilterMin.Controls.Add(this.lblImgFilterMin);
            this.pnlImgFilterMin.Controls.Add(this.radImgFilterMinN);
            this.pnlImgFilterMin.Controls.Add(this.radImgFilterMinL);
            resources.ApplyResources(this.pnlImgFilterMin, "pnlImgFilterMin");
            this.pnlImgFilterMin.Name = "pnlImgFilterMin";
            //
            // lblImgFilterMin
            //
            resources.ApplyResources(this.lblImgFilterMin, "lblImgFilterMin");
            this.lblImgFilterMin.Name = "lblImgFilterMin";
            //
            // radImgFilterMinN
            //
            resources.ApplyResources(this.radImgFilterMinN, "radImgFilterMinN");
            this.radImgFilterMinN.Name = "radImgFilterMinN";
            //
            // radImgFilterMinL
            //
            resources.ApplyResources(this.radImgFilterMinL, "radImgFilterMinL");
            this.radImgFilterMinL.Name = "radImgFilterMinL";
            //
            // pnlImgFilterMag
            //
            this.pnlImgFilterMag.Controls.Add(this.lblImgFilterMag);
            this.pnlImgFilterMag.Controls.Add(this.radImgFilterMagN);
            this.pnlImgFilterMag.Controls.Add(this.radImgFilterMagL);
            resources.ApplyResources(this.pnlImgFilterMag, "pnlImgFilterMag");
            this.pnlImgFilterMag.Name = "pnlImgFilterMag";
            //
            // lblImgFilterMag
            //
            resources.ApplyResources(this.lblImgFilterMag, "lblImgFilterMag");
            this.lblImgFilterMag.Name = "lblImgFilterMag";
            //
            // radImgFilterMagN
            //
            resources.ApplyResources(this.radImgFilterMagN, "radImgFilterMagN");
            this.radImgFilterMagN.Name = "radImgFilterMagN";
            //
            // radImgFilterMagL
            //
            resources.ApplyResources(this.radImgFilterMagL, "radImgFilterMagL");
            this.radImgFilterMagL.Name = "radImgFilterMagL";
            //
            // grpImgWrap
            //
            this.grpImgWrap.Controls.Add(this.pnlImgWrapS);
            this.grpImgWrap.Controls.Add(this.pnlImgWrapT);
            resources.ApplyResources(this.grpImgWrap, "grpImgWrap");
            this.grpImgWrap.Name = "grpImgWrap";
            this.grpImgWrap.TabStop = false;
            //
            // pnlImgWrapS
            //
            this.pnlImgWrapS.Controls.Add(this.lblImgWrapS);
            this.pnlImgWrapS.Controls.Add(this.radImgWrapSClamp);
            this.pnlImgWrapS.Controls.Add(this.radImgWrapSRepeat);
            this.pnlImgWrapS.Controls.Add(this.radImgWrapSMirror);
            resources.ApplyResources(this.pnlImgWrapS, "pnlImgWrapS");
            this.pnlImgWrapS.Name = "pnlImgWrapS";
            //
            // lblImgWrapS
            //
            resources.ApplyResources(this.lblImgWrapS, "lblImgWrapS");
            this.lblImgWrapS.Name = "lblImgWrapS";
            //
            // radImgWrapSClamp
            //
            resources.ApplyResources(this.radImgWrapSClamp, "radImgWrapSClamp");
            this.radImgWrapSClamp.Name = "radImgWrapSClamp";
            //
            // radImgWrapSRepeat
            //
            resources.ApplyResources(this.radImgWrapSRepeat, "radImgWrapSRepeat");
            this.radImgWrapSRepeat.Name = "radImgWrapSRepeat";
            //
            // radImgWrapSMirror
            //
            resources.ApplyResources(this.radImgWrapSMirror, "radImgWrapSMirror");
            this.radImgWrapSMirror.Name = "radImgWrapSMirror";
            //
            // pnlImgWrapT
            //
            this.pnlImgWrapT.Controls.Add(this.lblImgWrapT);
            this.pnlImgWrapT.Controls.Add(this.radImgWrapTClamp);
            this.pnlImgWrapT.Controls.Add(this.radImgWrapTRepeat);
            this.pnlImgWrapT.Controls.Add(this.radImgWrapTMirror);
            resources.ApplyResources(this.pnlImgWrapT, "pnlImgWrapT");
            this.pnlImgWrapT.Name = "pnlImgWrapT";
            //
            // lblImgWrapT
            //
            resources.ApplyResources(this.lblImgWrapT, "lblImgWrapT");
            this.lblImgWrapT.Name = "lblImgWrapT";
            //
            // radImgWrapTClamp
            //
            resources.ApplyResources(this.radImgWrapTClamp, "radImgWrapTClamp");
            this.radImgWrapTClamp.Name = "radImgWrapTClamp";
            //
            // radImgWrapTRepeat
            //
            resources.ApplyResources(this.radImgWrapTRepeat, "radImgWrapTRepeat");
            this.radImgWrapTRepeat.Name = "radImgWrapTRepeat";
            //
            // radImgWrapTMirror
            //
            resources.ApplyResources(this.radImgWrapTMirror, "radImgWrapTMirror");
            this.radImgWrapTMirror.Name = "radImgWrapTMirror";
            //
            // tpgMapping
            //
            this.tpgMapping.BackColor = System.Drawing.SystemColors.Control;
            this.tpgMapping.Controls.Add(this.pnlMapping);
            resources.ApplyResources(this.tpgMapping, "tpgMapping");
            this.tpgMapping.Name = "tpgMapping";
            //
            // pnlMapping
            //
            this.pnlMapping.Controls.Add(this.cmbMapMethod);
            this.pnlMapping.Controls.Add(this.lblMapMethod);
            this.pnlMapping.Controls.Add(this._grpSrtMtx);
            this.pnlMapping.Controls.Add(this._grpProjectionMapping);
            this.pnlMapping.Controls.Add(this._lblMappingNotice);
            resources.ApplyResources(this.pnlMapping, "pnlMapping");
            this.pnlMapping.Name = "pnlMapping";
            //
            // cmbMapMethod
            //
            resources.ApplyResources(this.cmbMapMethod, "cmbMapMethod");
            this.cmbMapMethod.Name = "cmbMapMethod";
            this.cmbMapMethod.SelectedItemData = null;
            //
            // lblMapMethod
            //
            resources.ApplyResources(this.lblMapMethod, "lblMapMethod");
            this.lblMapMethod.Name = "lblMapMethod";
            //
            // _grpSrtMtx
            //
            this._grpSrtMtx.Controls.Add(this._pnlTextureMtx);
            resources.ApplyResources(this._grpSrtMtx, "_grpSrtMtx");
            this._grpSrtMtx.Name = "_grpSrtMtx";
            this._grpSrtMtx.TabStop = false;
            //
            // _pnlTextureMtx
            //
            this._pnlTextureMtx.ControlColor = System.Drawing.Color.Empty;
            resources.ApplyResources(this._pnlTextureMtx, "_pnlTextureMtx");
            this._pnlTextureMtx.Name = "_pnlTextureMtx";
            this._pnlTextureMtx.TargetTexMtx = null;
            this._pnlTextureMtx.UseAnimationMark = false;
            //
            // _grpProjectionMapping
            //
            this._grpProjectionMapping.Controls.Add(this._lblMessageProjection);
            this._grpProjectionMapping.Controls.Add(this._lblAdjustPaneSRNote);
            this._grpProjectionMapping.Controls.Add(this._lblAutoScaleNote);
            this._grpProjectionMapping.Controls.Add(this._chkAdjustProjectionPaneSR);
            this._grpProjectionMapping.Controls.Add(this._chkAutoScalePaneSize);
            this._grpProjectionMapping.Controls.Add(this._chkAutoScale);
            this._grpProjectionMapping.Controls.Add(this._lblProjectionTrans);
            this._grpProjectionMapping.Controls.Add(this._fudProjectionTrans);
            this._grpProjectionMapping.Controls.Add(this._lblProjectionScale);
            this._grpProjectionMapping.Controls.Add(this._fudProjectionScale);
            resources.ApplyResources(this._grpProjectionMapping, "_grpProjectionMapping");
            this._grpProjectionMapping.Name = "_grpProjectionMapping";
            this._grpProjectionMapping.TabStop = false;
            //
            // _chkAdjustProjectionPaneSR
            //
            resources.ApplyResources(this._chkAdjustProjectionPaneSR, "_chkAdjustProjectionPaneSR");
            this._chkAdjustProjectionPaneSR.Name = "_chkAdjustProjectionPaneSR";
            this._chkAdjustProjectionPaneSR.UseVisualStyleBackColor = true;
            this._chkAdjustProjectionPaneSR.CheckedChanged += new System.EventHandler(this.Event_chkAdjustProjectionPaneSR_CheckedChanged);
            //
            // _chkAutoScalePaneSize
            //
            resources.ApplyResources(this._chkAutoScalePaneSize, "_chkAutoScalePaneSize");
            this._chkAutoScalePaneSize.Name = "_chkAutoScalePaneSize";
            this._chkAutoScalePaneSize.UseVisualStyleBackColor = true;
            this._chkAutoScalePaneSize.CheckedChanged += new System.EventHandler(this.Event_chkAutoScalePaneSize_CheckedChanged);
            //
            // _chkAutoScale
            //
            resources.ApplyResources(this._chkAutoScale, "_chkAutoScale");
            this._chkAutoScale.Name = "_chkAutoScale";
            this._chkAutoScale.UseVisualStyleBackColor = true;
            this._chkAutoScale.CheckedChanged += new System.EventHandler(this.Event_chkAutoScale_CheckedChanged);
            //
            // _lblProjectionTrans
            //
            resources.ApplyResources(this._lblProjectionTrans, "_lblProjectionTrans");
            this._lblProjectionTrans.Name = "_lblProjectionTrans";
            //
            // _fudProjectionTrans
            //
            this._fudProjectionTrans.DecimalPlaces = 2;
            this._fudProjectionTrans.Increment = 1F;
            this._fudProjectionTrans.LabelX = "X :";
            this._fudProjectionTrans.LabelY = "Y :";
            this._fudProjectionTrans.Link = false;
            resources.ApplyResources(this._fudProjectionTrans, "_fudProjectionTrans");
            this._fudProjectionTrans.Name = "_fudProjectionTrans";
            this._fudProjectionTrans.RoundByStepValue = false;
            this._fudProjectionTrans.TextBoxWidth = 62;
            this._fudProjectionTrans.UseAnimationMark = false;
            this._fudProjectionTrans.Vertical = false;
            this._fudProjectionTrans.XEnabled = true;
            this._fudProjectionTrans.YEnabled = true;
            this._fudProjectionTrans.OnFVec2Edit += new LayoutEditor.Controls.FVec2EditEventHandler(this.Event_fudProjectionTrans_OnFVec2Edit);
            //
            // _lblProjectionScale
            //
            resources.ApplyResources(this._lblProjectionScale, "_lblProjectionScale");
            this._lblProjectionScale.Name = "_lblProjectionScale";
            //
            // _fudProjectionScale
            //
            this._fudProjectionScale.DecimalPlaces = 2;
            this._fudProjectionScale.Increment = 0.1F;
            this._fudProjectionScale.LabelX = "X :";
            this._fudProjectionScale.LabelY = "Y :";
            this._fudProjectionScale.Link = false;
            resources.ApplyResources(this._fudProjectionScale, "_fudProjectionScale");
            this._fudProjectionScale.Name = "_fudProjectionScale";
            this._fudProjectionScale.RoundByStepValue = false;
            this._fudProjectionScale.TextBoxWidth = 62;
            this._fudProjectionScale.UseAnimationMark = false;
            this._fudProjectionScale.Vertical = false;
            this._fudProjectionScale.XEnabled = true;
            this._fudProjectionScale.YEnabled = true;
            this._fudProjectionScale.OnFVec2Edit += new LayoutEditor.Controls.FVec2EditEventHandler(this.Event_fudProjectionScale_OnFVec2Edit);
            //
            // _lblMappingNotice
            //
            resources.ApplyResources(this._lblMappingNotice, "_lblMappingNotice");
            this._lblMappingNotice.BackColor = System.Drawing.SystemColors.GradientActiveCaption;
            this._lblMappingNotice.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this._lblMappingNotice.Name = "_lblMappingNotice";
            //
            // tpgTexPatternAnim
            //
            this.tpgTexPatternAnim.BackColor = System.Drawing.SystemColors.Control;
            this.tpgTexPatternAnim.Controls.Add(this._ctlTexturePatternAnim);
            resources.ApplyResources(this.tpgTexPatternAnim, "tpgTexPatternAnim");
            this.tpgTexPatternAnim.Name = "tpgTexPatternAnim";
            //
            // _ctlTexturePatternAnim
            //
            resources.ApplyResources(this._ctlTexturePatternAnim, "_ctlTexturePatternAnim");
            this._ctlTexturePatternAnim.BackColor = System.Drawing.Color.Transparent;
            this._ctlTexturePatternAnim.Name = "_ctlTexturePatternAnim";
            this._ctlTexturePatternAnim.TargetTexMap = null;
            //
            // grpTexMap
            //
            this.grpTexMap.Controls.Add(this.btnAddMovieTexture);
            this.grpTexMap.Controls.Add(this.btnAttrChangeImage);
            this.grpTexMap.Controls.Add(this.btnTexMapMoveLeft);
            this.grpTexMap.Controls.Add(this.btnTexMapMoveRight);
            this.grpTexMap.Controls.Add(this.btnTexMapAdd);
            this.grpTexMap.Controls.Add(this.btnTexMapRemove);
            this.grpTexMap.Controls.Add(this.ctlTexMap3);
            this.grpTexMap.Controls.Add(this.ctlTexMap0);
            this.grpTexMap.Controls.Add(this.ctlTexMap1);
            this.grpTexMap.Controls.Add(this.ctlTexMap2);
            this.grpTexMap.Controls.Add(this.ctlTexMap4);
            this.grpTexMap.Controls.Add(this.ctlTexMap5);
            this.grpTexMap.Controls.Add(this.ctlTexMap6);
            this.grpTexMap.Controls.Add(this.ctlTexMap7);
            this.grpTexMap.Controls.Add(this.lblTexMap7);
            this.grpTexMap.Controls.Add(this.lblTexMap6);
            this.grpTexMap.Controls.Add(this.lblTexMap5);
            this.grpTexMap.Controls.Add(this.lblTexMap4);
            this.grpTexMap.Controls.Add(this.lblTexMap3);
            this.grpTexMap.Controls.Add(this.lblTexMap2);
            this.grpTexMap.Controls.Add(this.lblTexMap1);
            this.grpTexMap.Controls.Add(this.lblTexMap0);
            this.grpTexMap.FlatStyle = System.Windows.Forms.FlatStyle.System;
            resources.ApplyResources(this.grpTexMap, "grpTexMap");
            this.grpTexMap.Name = "grpTexMap";
            this.grpTexMap.TabStop = false;
            //
            // btnAddMovieTexture
            //
            resources.ApplyResources(this.btnAddMovieTexture, "btnAddMovieTexture");
            this.btnAddMovieTexture.Name = "btnAddMovieTexture";
            this.btnAddMovieTexture.Click += new System.EventHandler(this.Event_BtnAddMovieTexture_Click);
            //
            // btnAttrChangeImage
            //
            resources.ApplyResources(this.btnAttrChangeImage, "btnAttrChangeImage");
            this.btnAttrChangeImage.Name = "btnAttrChangeImage";
            //
            // btnTexMapAdd
            //
            resources.ApplyResources(this.btnTexMapAdd, "btnTexMapAdd");
            this.btnTexMapAdd.Name = "btnTexMapAdd";
            //
            // btnTexMapRemove
            //
            resources.ApplyResources(this.btnTexMapRemove, "btnTexMapRemove");
            this.btnTexMapRemove.Name = "btnTexMapRemove";
            //
            // ctlTexMap3
            //
            this.ctlTexMap3.AllowDrop = true;
            resources.ApplyResources(this.ctlTexMap3, "ctlTexMap3");
            this.ctlTexMap3.IsDraggable = false;
            this.ctlTexMap3.Name = "ctlTexMap3";
            this.ctlTexMap3.Selected = false;
            this.ctlTexMap3.TargetMaterialGUIAdapter = null;
            this.ctlTexMap3.TexMap = null;
            //
            // ctlTexMap0
            //
            this.ctlTexMap0.AllowDrop = true;
            this.ctlTexMap0.IsDraggable = false;
            resources.ApplyResources(this.ctlTexMap0, "ctlTexMap0");
            this.ctlTexMap0.Name = "ctlTexMap0";
            this.ctlTexMap0.Selected = false;
            this.ctlTexMap0.TargetMaterialGUIAdapter = null;
            this.ctlTexMap0.TexMap = null;
            //
            // ctlTexMap1
            //
            this.ctlTexMap1.AllowDrop = true;
            this.ctlTexMap1.IsDraggable = false;
            resources.ApplyResources(this.ctlTexMap1, "ctlTexMap1");
            this.ctlTexMap1.Name = "ctlTexMap1";
            this.ctlTexMap1.Selected = false;
            this.ctlTexMap1.TargetMaterialGUIAdapter = null;
            this.ctlTexMap1.TexMap = null;
            //
            // ctlTexMap2
            //
            this.ctlTexMap2.AllowDrop = true;
            this.ctlTexMap2.IsDraggable = false;
            resources.ApplyResources(this.ctlTexMap2, "ctlTexMap2");
            this.ctlTexMap2.Name = "ctlTexMap2";
            this.ctlTexMap2.Selected = false;
            this.ctlTexMap2.TargetMaterialGUIAdapter = null;
            this.ctlTexMap2.TexMap = null;
            //
            // ctlTexMap4
            //
            this.ctlTexMap4.AllowDrop = true;
            resources.ApplyResources(this.ctlTexMap4, "ctlTexMap4");
            this.ctlTexMap4.IsDraggable = false;
            this.ctlTexMap4.Name = "ctlTexMap4";
            this.ctlTexMap4.Selected = false;
            this.ctlTexMap4.TargetMaterialGUIAdapter = null;
            this.ctlTexMap4.TexMap = null;
            //
            // ctlTexMap5
            //
            this.ctlTexMap5.AllowDrop = true;
            resources.ApplyResources(this.ctlTexMap5, "ctlTexMap5");
            this.ctlTexMap5.IsDraggable = false;
            this.ctlTexMap5.Name = "ctlTexMap5";
            this.ctlTexMap5.Selected = false;
            this.ctlTexMap5.TargetMaterialGUIAdapter = null;
            this.ctlTexMap5.TexMap = null;
            //
            // ctlTexMap6
            //
            this.ctlTexMap6.AllowDrop = true;
            resources.ApplyResources(this.ctlTexMap6, "ctlTexMap6");
            this.ctlTexMap6.IsDraggable = false;
            this.ctlTexMap6.Name = "ctlTexMap6";
            this.ctlTexMap6.Selected = false;
            this.ctlTexMap6.TargetMaterialGUIAdapter = null;
            this.ctlTexMap6.TexMap = null;
            //
            // ctlTexMap7
            //
            this.ctlTexMap7.AllowDrop = true;
            resources.ApplyResources(this.ctlTexMap7, "ctlTexMap7");
            this.ctlTexMap7.IsDraggable = false;
            this.ctlTexMap7.Name = "ctlTexMap7";
            this.ctlTexMap7.Selected = false;
            this.ctlTexMap7.TargetMaterialGUIAdapter = null;
            this.ctlTexMap7.TexMap = null;
            //
            // lblTexMap7
            //
            resources.ApplyResources(this.lblTexMap7, "lblTexMap7");
            this.lblTexMap7.Name = "lblTexMap7";
            //
            // lblTexMap6
            //
            resources.ApplyResources(this.lblTexMap6, "lblTexMap6");
            this.lblTexMap6.Name = "lblTexMap6";
            //
            // lblTexMap5
            //
            resources.ApplyResources(this.lblTexMap5, "lblTexMap5");
            this.lblTexMap5.Name = "lblTexMap5";
            //
            // lblTexMap4
            //
            resources.ApplyResources(this.lblTexMap4, "lblTexMap4");
            this.lblTexMap4.Name = "lblTexMap4";
            //
            // lblTexMap3
            //
            resources.ApplyResources(this.lblTexMap3, "lblTexMap3");
            this.lblTexMap3.Name = "lblTexMap3";
            //
            // lblTexMap2
            //
            resources.ApplyResources(this.lblTexMap2, "lblTexMap2");
            this.lblTexMap2.Name = "lblTexMap2";
            //
            // lblTexMap1
            //
            resources.ApplyResources(this.lblTexMap1, "lblTexMap1");
            this.lblTexMap1.Name = "lblTexMap1";
            //
            // lblTexMap0
            //
            resources.ApplyResources(this.lblTexMap0, "lblTexMap0");
            this.lblTexMap0.Name = "lblTexMap0";
            //
            // MaterialTexturePage
            //
            this.Controls.Add(this.grpSelected);
            this.Controls.Add(this.grpTexMap);
            resources.ApplyResources(this, "$this");
            this.Name = "MaterialTexturePage";
            this.Sizable = true;
            this.grpSelected.ResumeLayout(false);
            this.pnlAttr.ResumeLayout(false);
            this.tabSetting.ResumeLayout(false);
            this.tpgImage.ResumeLayout(false);
            this.grpImgFilter.ResumeLayout(false);
            this.pnlImgFilterMin.ResumeLayout(false);
            this.pnlImgFilterMin.PerformLayout();
            this.pnlImgFilterMag.ResumeLayout(false);
            this.pnlImgFilterMag.PerformLayout();
            this.grpImgWrap.ResumeLayout(false);
            this.pnlImgWrapS.ResumeLayout(false);
            this.pnlImgWrapS.PerformLayout();
            this.pnlImgWrapT.ResumeLayout(false);
            this.pnlImgWrapT.PerformLayout();
            this.tpgMapping.ResumeLayout(false);
            this.pnlMapping.ResumeLayout(false);
            this.pnlMapping.PerformLayout();
            this._grpSrtMtx.ResumeLayout(false);
            this._grpProjectionMapping.ResumeLayout(false);
            this._grpProjectionMapping.PerformLayout();
            this.tpgTexPatternAnim.ResumeLayout(false);
            this.grpTexMap.ResumeLayout(false);
            this.ResumeLayout(false);

        }
        #endregion

        // テクスチャマップ管理
        private readonly TexCtrls.TexMapBox[] _texMapBoxes = new TexCtrls.TexMapBox[TexMapList.NumMaxTexture];
        private readonly Label[] _texMapLabels = new Label[TexMapList.NumMaxTexture];

        // テクスチャマップ番号
        private int _texMapNo { get; set; } = -1;

        // 前回選択されたGUIオブジェクトグループ
        PaneGuiAdapterGroup _oldTarget = null;

        // 動画テクスチャのダイアログ
        LoadMovieDlg _loadMovieDlg = new src.Forms.ToolWindows.PropertyEditWindow.Material.LoadMovieDlg(
            LayoutEditorCore.MovieTextureOutputDirectory);

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public MaterialTexturePage()
        {
            InitializeComponent();

            _texMapBoxes[0] = ctlTexMap0;
            _texMapBoxes[1] = ctlTexMap1;
            _texMapBoxes[2] = ctlTexMap2;

            _texMapLabels[0] = lblTexMap0;
            _texMapLabels[1] = lblTexMap1;
            _texMapLabels[2] = lblTexMap2;

            // ツールチップ初期設定
            ToolTipInitializer.Initialize(ttpHint);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        public override PropertyPageID PageID
        {
            get { return PropertyPageID.MaterialTexture; }
        }

        /// <summary>
        /// 対象のテクスチャ座標
        /// </summary>
        private TexCoord4 _TargetTexCoord
        {
            get
            {
                int texCoordIdx = Math.Min(this.ActiveTarget.NumVtxTexCoords, _texMapNo);
                var texCoords = this.ActiveMaterialOwner.TexCoords;
                return texCoords.ElementAtOrDefault(texCoordIdx);
            }
        }

        /// <summary>
        /// サブシーン
        /// </summary>
        private ISubScene SubScene
        {
            get
            {
                return this._OwnerPane?.OwnerSubScene;
            }
        }

        /// <summary>
        /// テクスチャパターン編集タブの更新イベントを受け取ります。
        /// </summary>
        void TexturePatternTabPageModifyHandler(object sender, EventArgs args)
        {
            NotifyPropertyChanged();
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void InitializeProperty()
        {
            #region テクスチャマップ

            // ボタン
            btnTexMapAdd.Click += new EventHandler(Event_BtnTexMapAdd_Click);
            btnTexMapRemove.Click += new EventHandler(Event_BtnTexMapRemove_Click);
            btnTexMapMoveLeft.Click += new EventHandler(Event_BtnTexMapMoveLeft_Click);
            btnTexMapMoveRight.Click += new EventHandler(Event_BtnTexMapMoveRight_Click);
            btnAddMovieTexture.Visible = LayoutEditorCore.MovieTextureEnabled;

            // ボックス
            for (int i = 0; i < _texMapBoxes.Length; i++)
            {
                _texMapBoxes[i].Tag = i;
                _texMapBoxes[i].GotFocus += new EventHandler(Event_TexMapBox_GotFocus);
                _texMapBoxes[i].DragEnter += new DragEventHandler(Event_TexMapBox_DragEnter);
                _texMapBoxes[i].DragDrop += new DragEventHandler(Event_TexMapBox_DragDrop);
                _texMapBoxes[i].IsDraggable = true;
            }

            #endregion

            #region アトリビュート

            // 画像変更
            btnAttrChangeImage.Click += new EventHandler(Event_BtnAttrChangeImage_Click);

            #endregion

            #region イメージ設定

            // wrapS
            radImgWrapSClamp.Tag = AttrTexWrap.Clamp;
            radImgWrapSRepeat.Tag = AttrTexWrap.Repeat;
            radImgWrapSMirror.Tag = AttrTexWrap.Mirror;
            radImgWrapSClamp.RadioChecked += new EventHandler(Event_RadImgWrapS_RadioChecked);
            radImgWrapSRepeat.RadioChecked += new EventHandler(Event_RadImgWrapS_RadioChecked);
            radImgWrapSMirror.RadioChecked += new EventHandler(Event_RadImgWrapS_RadioChecked);

            // wrapT
            radImgWrapTClamp.Tag = AttrTexWrap.Clamp;
            radImgWrapTRepeat.Tag = AttrTexWrap.Repeat;
            radImgWrapTMirror.Tag = AttrTexWrap.Mirror;
            radImgWrapTClamp.RadioChecked += new EventHandler(Event_RadImgWrapT_RadioChecked);
            radImgWrapTRepeat.RadioChecked += new EventHandler(Event_RadImgWrapT_RadioChecked);
            radImgWrapTMirror.RadioChecked += new EventHandler(Event_RadImgWrapT_RadioChecked);

            // magFilter
            radImgFilterMagN.Tag = AttrTexFilterMag.Near;
            radImgFilterMagL.Tag = AttrTexFilterMag.Linear;
            radImgFilterMagN.RadioChecked += new EventHandler(Event_RadImgFilterMag_RadioChecked);
            radImgFilterMagL.RadioChecked += new EventHandler(Event_RadImgFilterMag_RadioChecked);

            // minFilter
            radImgFilterMinN.Tag = AttrTexFilterMin.Near;
            radImgFilterMinL.Tag = AttrTexFilterMin.Linear;

            radImgFilterMinN.RadioChecked += new EventHandler(Event_RadImgFilterMin_RadioChecked);
            radImgFilterMinL.RadioChecked += new EventHandler(Event_RadImgFilterMin_RadioChecked);

            // 互換性を維持するためには、”Linear”を設定します。
            //_cabFiltering.ToolTipText = StringResMgr.Get( "PROP_COMPATIVILITY_TOOLTIP_TEXTUREFILTER" );

            #endregion

            #region マッピング設定

            // method
            // 選択項目はマテリアル毎に異なるので更新時に再作成
            cmbMapMethod.SelectedIndexChanged += new EventHandler(Event_CmbMapMethod_SelectedIndexChanged);

            // TODO:パネルにハンドラを設定します。
            _pnlTextureMtx.OnMatrixChanged += Event_PnlTextureMtx_Changed;

            #endregion

            #region テクスチャパターン設定
            // 更新ハンドラを設定します。
            _ctlTexturePatternAnim.OnTexMapTexSubListModify +=
            new EventHandler(TexturePatternTabPageModifyHandler);
            #endregion テクスチャパターン設定

            // ViewManagerへのメッセージハンドラを設定します
            _pnlTextureMtx.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
        }

        /// <summary>
        ///
        /// </summary>
        private bool ExistActiveMaterial
        {
            get
            {
                return this.ActiveTarget != null;
            }
        }

        /// <summary>
        /// 対象が読み取り専用か？
        /// </summary>
        private bool IsActiveMaterialReadOnly
        {
            get
            {
                return
                    this.ExistActiveMaterial &&
                    this.ActiveMaterialOwner != null &&
                    this.ActiveMaterialOwner.IsReadOnlyLocked;
            }
        }

        private IPane ActiveMaterialOwner
        {
            get
            {
                return ExistActiveMaterial ? this.ActiveTarget.IMaterial.OwnerPane : null;
            }
        }

        /// <summary>
        /// 読み込み専用でも編集を許可するかどうか？
        /// <remarks>
        /// 例外的に、編集を許可したいページでオーバーライドします。
        /// </remarks>
        /// </summary>
        protected override bool AllowEditReadOnlyTarget()
        {
            return true;
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void DoUpdateProperty_()
        {
            if (ExistActiveMaterial == false)
            {
                return;
            }

            // パネルがアニメーションマークを利用するかを設定します
            _pnlTextureMtx.UseAnimationMark = this.CanUseAnimationMark(SubScene);

            MaterialGUIAdapter target = this.ActiveTarget;
            TexMapList texMapList = this.TargetTexMapList;

            // テクスチャマップ番号調整
            if (texMapList.TexMaps.Count == 0)
            {
                DbgConsole.WriteLine("texMapNo is adjusted: {0} -> {1}", _texMapNo, -1);
                _texMapNo = -1;
            }
            else if ((_texMapNo == -1 && texMapList.TexMaps.Count > 0) || _texMapNo >= texMapList.TexMaps.Count)
            {
                DbgConsole.WriteLine("texMapNo is adjusted: {0} -> {1}", _texMapNo, 0);
                _texMapNo = 0;
            }

            DoUpdatePropertyTextureMap_(texMapList);

            // 未選択状態の場合はこれ以降非表示
            if (_texMapNo == -1)
            {
                pnlAttr.Visible = false;
                tabSetting.Visible = false;
                return;
            }
            else
            {
                pnlAttr.Visible = true;
                tabSetting.Visible = true;
            }

            TexMap texMap = texMapList[_texMapNo];
            TexImage texImage = texMap.TexImage;

            // サムネイル
            ctlAttrColor.Thumbnail = texImage;
            ctlAttrAlpha.Thumbnail = texImage;

            // アトリビュート
            lblAttrName.Text = texImage.Texture.Name;
            lblAttrFormat.Text = texImage.Texture.FormatText;
            lblAttrSize.Text = texImage.Texture.SizeText;
            tabSetting.SuspendLayout();

            DoUpdatePropertyImage_(texMap, texImage);
            DoUpdatePropertyMapping_();

            //----------------------------------------------------------
            //
            // 投影マップ
            if (!texMap.TexGen.IsUVMethod)
            {
                //// タブを非表示
            }
            // その他
            else
            {
                // タブを表示
                if (!tabSetting.TabPages.Contains(tpgTexPatternAnim))
                {
                    tabSetting.TabPages.Add(tpgTexPatternAnim);
                }
            }

            // 派生部品で、派生元でアニメーションが設定済みでなければ編集可能。
            var targetTexMap = this.ActiveTarget.IMaterial.GetMaterialTexMap(_texMapNo);
            _ctlTexturePatternAnim.Enabled = targetTexMap != null && !targetTexMap.ITextureChanger.TextureIndexIAnmAttr.IsReadOnlyLocked();
            _ctlTexturePatternAnim.TargetTexMap = this.TargetTexMap;
            _ctlTexturePatternAnim.UpdateProperty();

            // テクスチャだけ上書き
            {
                bool isTextureOverwritingEnabled = this.ActiveTarget.IsTextureOverwritingEnabled;
                foreach (Control control in tpgMapping.Controls)
                {
                    control.Enabled = !isTextureOverwritingEnabled;
                }
                foreach (Control control in tpgTexPatternAnim.Controls)
                {
                    control.Enabled = !isTextureOverwritingEnabled;
                }
                btnTexMapAdd.Enabled = !isTextureOverwritingEnabled;
                btnTexMapRemove.Enabled = !isTextureOverwritingEnabled;
                btnAddMovieTexture.Enabled = !isTextureOverwritingEnabled;
            }

            // 連動ボタンの更新
            if (_oldTarget != Target)
            {
                _oldTarget = Target;
                _pnlTextureMtx.UpdateLinkButton();
            }

            // 同時編集
            Color color = GetMultiEditColor();
            Color controlColor = GetMultiEditPanelColor();
            grpImgWrap.BackColor = controlColor;
            grpImgFilter.BackColor = controlColor;
            lblMapMethod.BackColor = controlColor;
            _fudProjectionScale.TextBoxBackColor = color;
            _fudProjectionTrans.TextBoxBackColor = color;
            _chkAutoScale.BackColor = controlColor;
            _chkAutoScalePaneSize.BackColor = controlColor;
            _chkAdjustProjectionPaneSR.BackColor = controlColor;
            _pnlTextureMtx.ControlColor = color;

            tabSetting.ResumeLayout();
        }

        /// <summary>
        ///
        /// </summary>
        private void DoUpdatePropertyTextureMap_(TexMapList texMapList)
        {
            // ボタン
            btnTexMapAdd.Enabled = !this.IsActiveMaterialReadOnly && TextureManager.HasUsableTextures() && texMapList.TexMaps.Count < TexMapList.NumMaxTexture;
            btnTexMapRemove.Enabled = !this.IsActiveMaterialReadOnly && _texMapNo != -1;
            btnAttrChangeImage.Enabled = !this.IsActiveMaterialReadOnly && _texMapNo != -1;
            btnTexMapMoveLeft.Enabled = !this.IsActiveMaterialReadOnly && _texMapNo != -1 && _texMapNo > 0;
            btnTexMapMoveRight.Enabled = !this.IsActiveMaterialReadOnly && _texMapNo != -1 && _texMapNo < (texMapList.TexMaps.Count - 1);
            btnAddMovieTexture.Enabled = !this.IsActiveMaterialReadOnly && texMapList.TexMaps.Count < TexMapList.NumMaxTexture;

            // ボックス
            for (int i = 0; i < _texMapBoxes.Length; i++)
            {
                if (i < texMapList.TexMaps.Count)
                {
                    _texMapBoxes[i].TexMap = texMapList[i];
                    _texMapBoxes[i].TargetMaterialGUIAdapter = this.ActiveTarget;
                    _texMapBoxes[i].TabStop = true;
                    _texMapLabels[i].Enabled = true;
                }
                else
                {
                    _texMapBoxes[i].TexMap = null;
                    _texMapBoxes[i].TargetMaterialGUIAdapter = null;
                    _texMapBoxes[i].TabStop = false;
                    _texMapLabels[i].Enabled = false;
                }

                // 選択テクスチャ番号
                _texMapBoxes[i].Selected = (i == _texMapNo);
            }
        }

        /// <summary>
        ///
        /// </summary>
        private void DoUpdatePropertyImage_(TexMap texMap, TexImage texImage)
        {
            grpImgFilter.Enabled = !this.IsActiveMaterialReadOnly;
            grpImgWrap.Enabled = !this.IsActiveMaterialReadOnly;

            // wrapS
            radImgWrapSClamp.SetCheckedByTag(texMap.WrapS);
            radImgWrapSRepeat.SetCheckedByTag(texMap.WrapS);
            radImgWrapSMirror.SetCheckedByTag(texMap.WrapS);

            //
            TexImagePixelFmt format = texImage.Texture.PixelFormat;
            int texWidth = texImage.Texture.Width;
            int texHeight = texImage.Texture.Height;

            // べき乗制限
            bool mirrorEnableS = LayoutEditorCore.PlatformDetail.CheckTextureMirrorRepeatEnabled(texImage.Texture.PixelFormat, texImage.Texture.Width);
            radImgWrapSRepeat.Enabled = mirrorEnableS;
            radImgWrapSMirror.Enabled = mirrorEnableS;

            // wrapT
            radImgWrapTClamp.SetCheckedByTag(texMap.WrapT);
            radImgWrapTRepeat.SetCheckedByTag(texMap.WrapT);
            radImgWrapTMirror.SetCheckedByTag(texMap.WrapT);

            // べき乗制限
            bool mirrorEnableT = LayoutEditorCore.PlatformDetail.CheckTextureMirrorRepeatEnabled(texImage.Texture.PixelFormat, texImage.Texture.Height);
            radImgWrapTRepeat.Enabled = mirrorEnableT;
            radImgWrapTMirror.Enabled = mirrorEnableT;

            // magFilter
            radImgFilterMagN.SetCheckedByTag(texMap.MagFilter);
            radImgFilterMagL.SetCheckedByTag(texMap.MagFilter);

            // minFilter
            radImgFilterMinN.SetCheckedByTag(texMap.MinFilter);
            radImgFilterMinL.SetCheckedByTag(texMap.MinFilter);


            bool mipmap = texMap.Mipmap;
            radImgFilterMinN.Enabled = !mipmap;
            radImgFilterMinL.Enabled = !mipmap;
        }

        /// <summary>
        ///
        /// </summary>
        private void DoUpdatePropertyMapping_()
        {
            MaterialGUIAdapter target = this.ActiveTarget;
            TexMapList texMapList = this.TargetTexMapList;
            TexMap texMap = texMapList[_texMapNo];

            // ページがある場合のみ更新
            if (tabSetting.TabPages.Contains(tpgMapping))
            {
                pnlMapping.Enabled = !this.IsActiveMaterialReadOnly;

                TexGen texGen = texMap.TexGen;
                TexMtx texMtx = texGen.TexMtx;

                bool paneBasedProjection = texGen.Method == LETexGenMethod.PaneBasedProjection || texGen.Method == LETexGenMethod.PaneBasedPerspectiveProjection;

                // マッピング方法数
                DoUpdateMappingMethod_(target);

                // マッピング方法
                cmbMapMethod.SetSelectedItemData(texGen.Method);
                _chkAutoScale.Enabled = !texGen.IsUVMethod && (texGen.Method != LETexGenMethod.PaneBasedProjection && texGen.Method != LETexGenMethod.PaneBasedPerspectiveProjection);
                _chkAutoScalePaneSize.Enabled = !texGen.IsUVMethod && paneBasedProjection;
                // ペインの SR を考慮して投影機能は透視投影でも平行投影でも同じ結果になり紛らわしいため、透視投影の場合は強制的に OFF に設定しています。
                _chkAdjustProjectionPaneSR.Enabled = !texGen.IsUVMethod && texGen.Method == LETexGenMethod.PaneBasedProjection;

                _lblMessageProjection.Visible = !texGen.IsUVMethod;
                _lblAutoScaleNote.Visible = paneBasedProjection;
                _lblAdjustPaneSRNote.Visible = paneBasedProjection;

                // ペイン位置相対の投影の場合、ペインの SR を考慮して投影する機能に補足説明が必要なためそれぞれ設定する。
                if (texGen.Method == LETexGenMethod.PaneBasedProjection)
                {
                    this.ttpHint.SetToolTip(this._lblAdjustPaneSRNote, StringResMgr.Get("PROP_MAT_TEX_MSG_PANE_BASED_SR_ORTHO_PROJ_TOOLTIP"));
                }
                else if (texGen.Method == LETexGenMethod.PaneBasedPerspectiveProjection)
                {
                    this.ttpHint.SetToolTip(this._lblAdjustPaneSRNote, StringResMgr.Get("PROP_MAT_TEX_MSG_PANE_BASED_SR_PERSP_PROJ_TOOLTIP"));
                }

                // 投影マッピング
                _fudProjectionScale.FVec2Value = this.TargetTexMap.TexGen.ProjectionScale;
                _fudProjectionTrans.FVec2Value = this.TargetTexMap.TexGen.ProjectionOffset;
                _chkAutoScale.SetChecked(this.TargetTexMap.TexGen.IsFittingLayoutSizeEnabled);
                _chkAutoScalePaneSize.SetChecked(this.TargetTexMap.TexGen.IsFittingPaneSizeEnabled);
                _chkAdjustProjectionPaneSR.SetChecked(this.TargetTexMap.TexGen.IsAdjustProjectionPaneSREnabled);

                // TextureSRT パネルに値を設定します。
                _pnlTextureMtx.TargetTexMtx = target.IMaterial.ITexMtxSet[_texMapNo];
                _pnlTextureMtx.Set(texMtx.ScaleS, texMtx.ScaleT, texMtx.Rotate, texMtx.TransS, texMtx.TransT);

                cmbMapMethod.Enabled = target.IsTextureMappingEditable;
                _grpSrtMtx.Enabled = target.IsTextureMappingEditable;
                _grpProjectionMapping.Enabled = target.IsTextureMappingEditable && !texGen.IsUVMethod;
                _lblMappingNotice.Visible = !target.IsTextureMappingEditable && !texGen.IsUVMethod;
            }
        }

        /// <summary>
        /// マッピング方法を初期化します。
        /// </summary>
        private void DoUpdateMappingMethod_(MaterialGUIAdapter target)
        {
            // 候補数に変更があれば初期化します。
            int numTexCoords = target.NumVtxTexCoords;
            int prevNumTexCoords = cmbMapMethod.Tag != null ? (int)cmbMapMethod.Tag : 0;

            if (prevNumTexCoords != numTexCoords)
            {
                cmbMapMethod.Tag = numTexCoords;

                cmbMapMethod.Items.Clear();

                int numVtxTexCoords = target.NumVtxTexCoords;
                if (numVtxTexCoords >= 1) { cmbMapMethod.AddItem("PROP_MAT_TEX_MAP_METHOD_UV0", LETexGenMethod.UV0, true); }
                if (numVtxTexCoords >= 2) { cmbMapMethod.AddItem("PROP_MAT_TEX_MAP_METHOD_UV1", LETexGenMethod.UV1, true); }
                if (numVtxTexCoords >= 3) { cmbMapMethod.AddItem("PROP_MAT_TEX_MAP_METHOD_UV2", LETexGenMethod.UV2, true); }

                // 投影マップ
                cmbMapMethod.AddItem("PROP_MAT_TEX_MAP_METHOD_ORTHO_PROJECTION", LETexGenMethod.OrthogonalProjection, true);

                // ペイン位置相対の投影
                cmbMapMethod.AddItem("PROP_MAT_TEX_MAP_METHOD_PANEBASE_PROJECTION", LETexGenMethod.PaneBasedProjection, true);

                // 透視投影マップ
                cmbMapMethod.AddItem("PROP_MAT_TEX_MAP_METHOD_PERSPECTIVE_PROJECTION", LETexGenMethod.PerspectiveProjection, true);

                // ペイン位置相対の透視投影
                cmbMapMethod.AddItem("PROP_MAT_TEX_MAP_METHOD_PANEBASE_PERSPECTIVE_PROJECTION", LETexGenMethod.PaneBasedPerspectiveProjection, true);
            }
        }

        /// <summary>
        /// アニメーションマークを更新します。
        /// </summary>
        private void UpdateAnimationMark()
        {
            _pnlTextureMtx.UpdateAnimationMark();
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region ターゲット取得ヘルパ

        /// <summary>
        /// ターゲットテクスチャマップリスト。
        /// </summary>
        private TexMapList TargetTexMapList
        {
            get { return this.ActiveTarget.TexMapList; }
        }

        /// <summary>
        /// ターゲットテクスチャマップリスト。
        /// </summary>
        private IEnumerable<TexMapList> TargetTexMapLists
        {
            get { return this.ActiveTargets.Select(adpt => adpt.TexMapList); }
        }

        /// <summary>
        /// ターゲットテクスチャマップ
        /// </summary>
        private TexMap TargetTexMap
        {
            get
            {
                Debug.Assert(0 <= _texMapNo && _texMapNo < this.TargetTexMapList.TexMaps.Count);
                return this.TargetTexMapList[_texMapNo];
            }
        }

        /// <summary>
        /// ターゲットテクスチャマップ
        /// </summary>
        private IEnumerable<TexMap> TargetTexMaps
        {
            get
            {
                Debug.Assert(0 <= _texMapNo);
                return this.TargetTexMapLists.Where(list => _texMapNo < list.TexMaps.Count).Select(list => list[_texMapNo]);
            }
        }

        #endregion

        #region イベントハンドラ
        #region テクスチャマップ
        // 追加
        private void Event_BtnTexMapAdd_Click(object sender, EventArgs e)
        {
            MaterialGUIAdapter target = this.ActiveTarget;
            TexMapList texMapList = target.TexMapList;

            // 追加可能確認
            if (!texMapList.CanAddStandardTexMap(target))
            {
                MsgBox.WarningRes("PROP_MAT_TEX_MSG_ADDDISABLE");
                return;
            }

            // ダイアログ表示
            TextureAddDialog dlg = new TextureAddDialog(target, AppSetting.ProjectSettings.CaptureTextureFunctionEnabled);
            if (dlg.ShowDialog(this.Owner.Owner) == DialogResult.OK)
            {
                LETexGenMethod method = dlg.Method;
                Texture texture = dlg.Texture;
                TexMapKind kind = dlg.Kind;
                if(texture == null)
                {
                    return;
                }

                // 設定された名前のテクスチャがキャプチャテクスチャの場合、このマテリアルに設定可能かチェックします。
                if (!CanSetCaptureTexture(texture.Name))
                {
                    return;
                }

                // 作成
                TexMap texMap = new TexMap(TexImage.Create(texture), method, kind);

                // 挿入位置
                int addTexMapNo = _texMapNo + 1;

                // 挿入
                texMapList.TexMaps.Insert(addTexMapNo, texMap);
                texMapList.AdjustTexMtxID();
                _texMapNo = addTexMapNo;

                using (new GUIUpdating(this))
                {
                    UpdateProperty();
                }
                NotifyPropertyChanged();
            }
        }

        // 設定された名前のテクスチャがキャプチャテクスチャの場合、このマテリアルに設定可能かチェックします
        private bool CanSetCaptureTexture(String textureName)
        {
            IPane obstaclePane = PaneHelper.FindInvalidPaneForMaterialCaptureTextureInput(ActiveTarget.IMaterial.OwnerPane, textureName);

            if (obstaclePane != null)
            {
                string msg = StringResMgr.Get("PROP_MAT_TEX_MSG_ADD_TEXTURE_FAILED_BECAUSE_CAPTURE_TEXTURE_IN_PARENT_TREE", obstaclePane.PaneName);
                MessageBox.Show(this, msg, LayoutEditor.StringResMgr.Get("PROP_MAT_CATEGORY_TEXTURE"), MessageBoxButtons.OK);
                return false;
            }

            return true;
        }

        // 削除
        private void Event_BtnTexMapRemove_Click(object sender, EventArgs e)
        {
            // 確認
            if (!MsgBox.OkCancelRes("PROP_MAT_TEX_MSG_REMOVE"))
            {
                return;
            }

            // 削除
            // 選択番号の変更は UpdateProperty_ で行われる
            TexMapList texMapList = this.TargetTexMapList;
            texMapList.TexMaps.RemoveAt(_texMapNo);
            texMapList.AdjustTexMtxID();

            using (new GUIUpdating(this))
            {
                UpdateProperty();
            }
            NotifyPropertyChanged();
        }

        // 動画を静止画に変換する関数
        [DllImport("MovieToTexture.dll", EntryPoint = "ConvertMovieToTexture", CharSet = CharSet.Unicode)]
        public static extern int ConvertMovieToTexture(
            out int frameCount,
            out int width,
            out int height,
            [MarshalAs(UnmanagedType.LPWStr)]string inputFileName,
            [MarshalAs(UnmanagedType.LPWStr)]string outputDirName,
            [MarshalAs(UnmanagedType.LPWStr)]string textureNamePrefix,
            int beginFrame,
            int endFrame,
            bool alpha,
            int paddingNum,
            bool underscoreEnabled);

        // 動画の追加
        private void Event_BtnAddMovieTexture_Click(object sender, EventArgs e)
        {
            MaterialGUIAdapter target = this.ActiveTarget;
            TexMapList texMapList = target.TexMapList;

            // 追加可能確認
            if (!texMapList.CanAddStandardTexMap(target))
            {
                MsgBox.WarningRes("PROP_MAT_TEX_MSG_ADDDISABLE");
                return;
            }

            // 動画追加のダイアログを表示
            if (_loadMovieDlg.ShowDialog(this) == DialogResult.OK)
            {
                string inputFileName = _loadMovieDlg.GetInputFileName();
                string outputDirName = _loadMovieDlg.GetOutputDirName();
                int beginFrame = _loadMovieDlg.GetBeginFrame();
                int endFrame = _loadMovieDlg.GetEndFrame();
                int firstFrameOfAnim = _loadMovieDlg.GetFirstFrameOfAnim();
                int stepFrameOfAnim = _loadMovieDlg.GetStepFrameOfAnim();
                bool alphaEnabled = _loadMovieDlg.GetAlphaEnabled();
                int paddingNum = _loadMovieDlg.GetPaddingNum();
                bool underscoreEnabled = _loadMovieDlg.GetUnderscoreEnabled();
                LoadMovie(inputFileName, outputDirName, beginFrame, endFrame, firstFrameOfAnim, stepFrameOfAnim, alphaEnabled, paddingNum, underscoreEnabled);
            }
        }

        // 動画の読み込み
        private void LoadMovie(string inputFileName, string outputDirName, int beginFrame, int endFrame, int firstFrameOfAnim, int stepFrameOfAnim, bool alphaEnabled, int paddingNum, bool underscoreEnabled)
        {
            // ディレクトリの作成
            try
            {
                if (!System.IO.Directory.Exists(outputDirName))
                {
                    System.IO.Directory.CreateDirectory(outputDirName);
                }
            }
            catch
            {
                string title = StringResMgr.Get("TEXTURE_MSG_DLG_TITLE");
                string msg = StringResMgr.Get("ERROR_CREATE_DIRECTORY_FAILED", outputDirName);
                LECore.LayoutEditorCore.MsgReporter.ReportError(title, msg);
                return;
            }

            // 動画の静止画への変換
            int frameCount;
            int width;
            int height;
            string textureNamePrefix = System.IO.Path.GetFileNameWithoutExtension(inputFileName);
            int result = ConvertMovieToTexture(out frameCount, out width, out height, inputFileName, outputDirName, textureNamePrefix, beginFrame, endFrame, alphaEnabled, paddingNum, underscoreEnabled);
            if (result < 0)
            {
                string title = StringResMgr.Get("TEXTURE_MSG_DLG_TITLE");
                string msg = StringResMgr.Get("ERROR_LOAD_MOVIE_FAILED", inputFileName, (uint)result);
                LECore.LayoutEditorCore.MsgReporter.ReportError(title, msg);
                return;
            }

            // 開始フレームと終了フレームを 0～frameCount の範囲に調整する
            beginFrame = Math.Max(beginFrame, 0);
            endFrame = Math.Min(endFrame, frameCount - 1);
            if (endFrame - beginFrame + 1 <= 0)
            {
                return;
            }

            // テクスチャ名の列挙
            string[] textureNames = new string[endFrame - beginFrame + 1];
            string underscore = underscoreEnabled ? "_" : "";
            string paddingFormat = "D" + paddingNum.ToString();
            for (int i = beginFrame; i <= endFrame; i++)
            {
                textureNames[i - beginFrame] = outputDirName + "\\" + textureNamePrefix + underscore + i.ToString(paddingFormat) + ".tga";
            }

            // テクスチャの登録
            TextureMgrManipulator textureMgrManipulator = new TextureMgrManipulator();
            textureMgrManipulator.BindTarget(SubScene.ITextureMgr);
            textureMgrManipulator.RegisterITextureImageSetFromFile(textureNames);

            // TexMap の作成
            string firstTextureName = System.IO.Path.GetFileNameWithoutExtension(textureNames[0]);
            TexMap texMap = new TexMap(TexImage.Create(firstTextureName, null), LETexGenMethod.UV0, TexMapKind.Normal);
            int addTexMapNo = _texMapNo + 1;
            ActiveTarget.TexMapList.TexMaps.Insert(addTexMapNo, texMap);
            ActiveTarget.TexMapList.AdjustTexMtxID();

            // テクスチャリストの追加
            int countOfSubList = texMap.CountOfSubList;
            foreach (string textureName in textureNames)
            {
                texMap.AddTextureToSubList(System.IO.Path.GetFileNameWithoutExtension(textureName));
            }
            if (_ctlTexturePatternAnim.OnTexMapTexSubListModify != null)
            {
                // 更新を通知
                _ctlTexturePatternAnim.OnTexMapTexSubListModify(this, null);
            }

            // アニメーションカーブの作成
            CreateMovieTextureAnimationCurve(addTexMapNo, countOfSubList, beginFrame, endFrame, firstFrameOfAnim, stepFrameOfAnim);

            // 更新
            _texMapNo = addTexMapNo;
            using (new GUIUpdating(this))
            {
                UpdateProperty();
            }
            NotifyPropertyChanged();
        }

        // 動画テクスチャのアニメーションカーブの作成
        void CreateMovieTextureAnimationCurve(int addTexMapNo, int countOfSubList, int beginFrame, int endFrame, int firstFrameOfAnim, int stepFrameOfAnim)
        {
            IAnmAttribute[] patternAnimAttrs = ActiveMaterialOwner.GetAnimationTargetAttributeSet(ParamaterKind.Animation_TexturePattern);
            LayoutEditor.Forms.ToolWindows.CurveEditWindow.TargetAnmAttributeSet targetAttrSet = new CurveEditWindow.TargetAnmAttributeSet();
            IAnmAttribute[] movieTextureAttrSet = { };
            targetAttrSet.SetTargetAttribute(patternAnimAttrs, delegate { return true; });
            targetAttrSet.BeginKeySelectChange();
            {
                // 既存のキーをすべて削除する
                targetAttrSet.SelectKey(targetAttrSet._TargetKeyFrameSet);
                targetAttrSet.DeleteSlectedKey();

                // キーの設定
                AnmCurveManipulator anmCurveMnp = new AnmCurveManipulator();
                anmCurveMnp.BindTarget(patternAnimAttrs[addTexMapNo].ICurrentAnimationCurve);
                anmCurveMnp.PreInfinity = AnmCurveInfinityType.Constant;
                anmCurveMnp.PostInfinity = AnmCurveInfinityType.Constant;
                for (int i = beginFrame; i <= endFrame; i++)
                {
                    int frame = firstFrameOfAnim + stepFrameOfAnim * (i - beginFrame);
                    anmCurveMnp.MakeKeyFrame(frame, countOfSubList + i - beginFrame);
                }
            }
            targetAttrSet.EndKeySelectChange();
        }

        // 左に移動
        private void Event_BtnTexMapMoveLeft_Click(object sender, EventArgs e)
        {
            // 対象
            TexMapList texMapList = this.TargetTexMapList;
            TexMap texMap = this.TargetTexMap;

            // リストから外して左隣りに挿入
            texMapList.TexMaps.RemoveAt(_texMapNo);
            _texMapNo--;
            texMapList.TexMaps.Insert(_texMapNo, texMap);
            texMapList.AdjustTexMtxID();

            // 左端に来た時の無効時フォーカス制御
            if (_texMapNo == 0)
            {
                btnTexMapMoveRight.Enabled = true;
                btnTexMapMoveRight.Focus();
            }

            using (new GUIUpdating(this))
            {
                UpdateProperty();
            }
            NotifyPropertyChanged();
        }

        // 右に移動
        private void Event_BtnTexMapMoveRight_Click(object sender, EventArgs e)
        {
            // 対象
            TexMapList texMapList = this.TargetTexMapList;
            TexMap texMap = this.TargetTexMap;

            // リストから外して右隣りに挿入
            texMapList.TexMaps.RemoveAt(_texMapNo);
            _texMapNo++;
            texMapList.TexMaps.Insert(_texMapNo, texMap);
            texMapList.AdjustTexMtxID();

            // 右端に来た時の無効時フォーカス制御
            if (_texMapNo == texMapList.TexMaps.Count - 1)
            {
                btnTexMapMoveLeft.Enabled = true;
                btnTexMapMoveLeft.Focus();
            }

            using (new GUIUpdating(this))
            {
                UpdateProperty();
            }
            NotifyPropertyChanged();
        }

        private void Event_TexMapBox_GotFocus(object sender, EventArgs e)
        {
            TexMapBox texMapBox = (TexMapBox)sender;
            int texMapNo = (int)texMapBox.Tag;

            // テクスチャマップ番号切り替え
            if (_texMapNo != texMapNo)
            {
                _texMapNo = texMapNo;
                using (new GUIUpdating(this))
                {
                    UpdateProperty();
                }
            }
        }

        /// <summary>
        /// DragEnter
        /// </summary>
        private void Event_TexMapBox_DragEnter(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(typeof(TextureMgrWindow.TextureMgrWindow.DragDropItem)))
            {
                // テクスチャウインドウからのドラッグ
                var item = (TextureMgrWindow.TextureMgrWindow.DragDropItem)e.Data.GetData(typeof(TextureMgrWindow.TextureMgrWindow.DragDropItem));
                if (item.SubScene == SubScene)
                {
                    e.Effect = DragDropEffects.Copy;
                }
                else
                {
                    e.Effect = DragDropEffects.None;
                }
            }
            else if (e.Data.GetDataPresent(typeof(TexMapBox.DragDropItem)))
            {
                var texMapBox = sender as TexMapBox;
                var item = (TexMapBox.DragDropItem)e.Data.GetData(typeof(TexMapBox.DragDropItem));
                // 同一プロパティウィンドウからのドラッグ
                if (texMapBox.HasTexMap &&
                    item.TargetMaterialGUIAdapter == this.ActiveTarget)
                {
                    e.Effect = DragDropEffects.Move;
                }
                else
                {
                    e.Effect = DragDropEffects.None;
                }
            }
            else
            {
                e.Effect = DragDropEffects.None;
            }
        }

        /// <summary>
        /// DragDrop
        /// </summary>
        private void Event_TexMapBox_DragDrop(object sender, DragEventArgs e)
        {
            if (e.Data.GetDataPresent(typeof(TextureMgrWindow.TextureMgrWindow.DragDropItem)))
            {
                // ドロップ情報からテクスチャの取得を試みます。
                var item = (TextureMgrWindow.TextureMgrWindow.DragDropItem)e.Data.GetData(typeof(TextureMgrWindow.TextureMgrWindow.DragDropItem));
                if (item.SubScene == SubScene)
                {
                    SubScene.BeginMassiveModify();

                    do
                    {
                        // TexMapBoxにセットします。
                        MaterialGUIAdapter target = this.ActiveTarget;
                        TexMapList texMapList = this.TargetTexMapList;

                        // 設定された名前のテクスチャがキャプチャテクスチャの場合、このマテリアルに設定可能かチェックします。
                        if (!CanSetCaptureTexture(item.TextureName))
                        {
                            break;
                        }

                        // 作成
                        TexImage texImage = null;
                        Texture texture = TextureManager.Search(item.TextureName);
                        if (texture == null)
                        {
                            // テクスチャが見つからなければ登録する
                            var manipulator = new TextureMgrManipulator();
                            manipulator.BindTarget(SubScene.ITextureMgr);
                            var images = manipulator.RegisterITextureImageSetFromFile(new[] { item.FilePath });
                            if (images.Length > 0)
                            {
                                Debug.Assert(images.Length == 1);

                                // テクスチャの登録が実行されるのはEndMassiveModify時で遅いので、
                                // 明示的にTextureManagerに追加する。
                                bool isOwnedByCurrentSubScene = SubScene.ITextureMgr == SubScene.ITextureMgr;
                                Texture newTexture = new Texture(images[0], isOwnedByCurrentSubScene);
                                TextureManager.Add(newTexture);
                            }
                            else
                            {
                                // エラーメッセージ
                                MessageReportDlg dlg = new MessageReportDlg(LayoutEditor.Forms.MessageReportDlg.ButtonTypes.Ok, false);
                                dlg.Title = StringResMgr.Get("ADDTEXTURE");
                                dlg.Message = StringResMgr.Get("SAMENAMETEXTURE") + "\r\n\r\n" + item.FilePath;
                                dlg.ShowDialog(this);
                                break;
                            }
                        }
                        texImage = TexImage.Create(item.TextureName, "");

                        if (texImage == null)
                        {
                            break;
                        }

                        // 挿入位置
                        TexMapBox texMapBox = sender as TexMapBox;
                        int addTexMapNo = (int)texMapBox.Tag;

                        if (texMapList.TexMaps.Count <= addTexMapNo)
                        {
                            addTexMapNo = texMapList.TexMaps.Count;

                            // 挿入
                            TexMap texMap = new TexMap(texImage, LETexGenMethod.UV0, TexMapKind.Normal);
                            texMapList.TexMaps.Insert(addTexMapNo, texMap);
                            texMapList.AdjustTexMtxID();
                            _texMapNo = addTexMapNo;

                            addTexMapNo = texMapList.TexMaps.Count;
                        }
                        else
                        {
                            // 上書き
                            texMapList[addTexMapNo].TexImage = texImage;
                        }

                        // TexMapBoxのフォーカスを設定
                        texMapBox.Focus();

                        // UI更新
                        using (new GUIUpdating(this))
                        {
                            UpdateProperty();
                        }
                        NotifyPropertyChanged();

                    } while (false);

                    SubScene.EndMassiveModify();
                }
            }
            else if (e.Data.GetDataPresent(typeof(TexMapBox.DragDropItem)))
            {
                var item = (TexMapBox.DragDropItem)e.Data.GetData(typeof(TexMapBox.DragDropItem));
                if (item.TargetMaterialGUIAdapter == this.ActiveTarget)
                {
                    SubScene.BeginMassiveModify();

                    MaterialGUIAdapter target = this.ActiveTarget;
                    TexMapList texMapList = this.TargetTexMapList;

                    TexMapBox texMapBox = sender as TexMapBox;
                    int addTexMapNo = (int)texMapBox.Tag;
                    TexMap texMap = item.TexMapBox.TexMap;

                    // 挿入位置
                    addTexMapNo = (texMapList.TexMaps.Count <= addTexMapNo) ? texMapList.TexMaps.Count - 1 : addTexMapNo;

                    if (_texMapNo != addTexMapNo)
                    {
                        // 移動元のTexMapを削除
                        texMapList.TexMaps.RemoveAt(_texMapNo);

                        // 新しい位置に挿入
                        texMapList.TexMaps.Insert(addTexMapNo, texMap);
                        texMapList.AdjustTexMtxID();

                        texMapBox.Focus();

                        using (new GUIUpdating(this))
                        {
                            UpdateProperty();
                        }
                        NotifyPropertyChanged();
                    }

                    SubScene.EndMassiveModify();
                }
            }
        }
        #endregion

        #region アトリビュート
        private void Event_BtnAttrChangeImage_Click(object sender, EventArgs e)
        {
            TexMap texMap = this.TargetTexMap;
            TexImage texImageOld = texMap.TexImage;

            IPane dynamicCapturePane = null;
            if (AppSetting.ProjectSettings.CaptureTextureFunctionEnabled &&
                ActiveTarget.IMaterial.OwnerPane.OwnerSubScene.IPartsLayout == null)
            {
                dynamicCapturePane = ActiveTarget.IMaterial.OwnerPane;
            }

            TextureSelectDialog dlg = new TextureSelectDialog(texImageOld, dynamicCapturePane);
            if (dlg.ShowDialog(this.Owner.Owner) == DialogResult.OK)
            {
                if(dlg.Texture == null)
                {
                    return;
                }

                TexImage texImageNew = TexImage.Create(dlg.Texture);

                // 異なる場合のみ
                if (texImageNew != texImageOld)
                {
                    // 設定された名前のテクスチャがキャプチャテクスチャの場合、このマテリアルに設定可能かチェックします。
                    IPane obstaclePane = PaneHelper.FindInvalidPaneForMaterialCaptureTextureInput(ActiveTarget.IMaterial.OwnerPane, dlg.Texture.Name);

                    if (obstaclePane != null)
                    {
                        string msg = StringResMgr.Get("PROP_MAT_TEX_MSG_ADD_TEXTURE_FAILED_BECAUSE_CAPTURE_TEXTURE_IN_PARENT_TREE", obstaclePane.PaneName);
                        MessageBox.Show(this, msg, LayoutEditor.StringResMgr.Get("PROP_MAT_CATEGORY_TEXTURE"), MessageBoxButtons.OK);
                        return;
                    }

                    texMap.TexImage = texImageNew;

                    using (new GUIUpdating(this))
                    {
                        UpdateProperty();
                    }
                    NotifyPropertyChanged();
                }
            }
        }
        #endregion

        #region イメージ設定
        private void Event_RadImgWrapS_RadioChecked(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            AttrTexWrap val = (AttrTexWrap)((UIRadioButton)sender).Tag;
            MultiEdit_((obj) => {
                TexMap texMap = obj as TexMap;
                texMap.WrapS = val;
                NotifyPropertyChanged();
            }, TargetTexMap, TargetTexMaps);
        }

        private void Event_RadImgWrapT_RadioChecked(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            AttrTexWrap val = (AttrTexWrap)((UIRadioButton)sender).Tag;
            MultiEdit_((obj) => {
                TexMap texMap = obj as TexMap;
                texMap.WrapT = val;
                NotifyPropertyChanged();
            }, TargetTexMap, TargetTexMaps);
        }

        private void Event_RadImgFilterMag_RadioChecked(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            AttrTexFilterMag val = (AttrTexFilterMag)((UIRadioButton)sender).Tag;
            MultiEdit_((obj) => {
                TexMap texMap = obj as TexMap;
                texMap.MagFilter = val;
                NotifyPropertyChanged();
            }, TargetTexMap, TargetTexMaps);
        }

        private void Event_RadImgFilterMin_RadioChecked(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            AttrTexFilterMin val = (AttrTexFilterMin)((UIRadioButton)sender).Tag;
            MultiEdit_((obj) => {
                TexMap texMap = obj as TexMap;
                texMap.MinFilter = val;
                NotifyPropertyChanged();
            }, TargetTexMap, TargetTexMaps);
        }
        #endregion

        #region マッピング設定

        /// <summary>
        /// マッピング方法 コンボボックス ハンドラ
        /// </summary>
        private void Event_CmbMapMethod_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            MaterialGUIAdapter target = this.ActiveTarget;
            MaterialGUIAdapter[] targets = this.ActiveTargets.ToArray();

            if (_texMapNo >= target.IMaterial.IMaterialTexMapSet.Length)
            {
                return;
            }

            LETexGenMethod method = (LETexGenMethod)cmbMapMethod.SelectedItemData;
            MultiEdit_((obj) => {
                MaterialGUIAdapter adapter = obj as MaterialGUIAdapter;
                if (_texMapNo >= adapter.IMaterial.IMaterialTexMapSet.Length)
                {
                    return;
                }

                TexGenManipulator texGenMnp = new TexGenManipulator();
                texGenMnp.BindTarget(adapter.IMaterial.IMaterialTexMapSet[_texMapNo]);
                texGenMnp.Method = method;
            }, target, targets);
        }

        /// <summary>
        /// テクスチャ行列パネル変更 ハンドラ
        /// </summary>
        private void Event_PnlTextureMtx_Changed(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            MaterialTextureEditEventArgs args = e as MaterialTextureEditEventArgs;

            MultiEdit_((obj) => {
                TexMap texMap = obj as TexMap;
                TexMtx texMtx = texMap.TexGen.TexMtx;
                if (texMtx != null)
                {
                    if ((args.Kind & MaterialTextureEditEventKind.Trans_U) != 0)
                        texMtx.TransS = _pnlTextureMtx.MtxTrans.X;
                    if ((args.Kind & MaterialTextureEditEventKind.Trans_V) != 0)
                        texMtx.TransT = _pnlTextureMtx.MtxTrans.Y;
                    if ((args.Kind & MaterialTextureEditEventKind.Rotate) != 0)
                        texMtx.Rotate = _pnlTextureMtx.MtxRotate;
                    if ((args.Kind & MaterialTextureEditEventKind.Scale_U) != 0)
                        texMtx.ScaleS = _pnlTextureMtx.MtxScale.X;
                    if ((args.Kind & MaterialTextureEditEventKind.Scale_V) != 0)
                        texMtx.ScaleT = _pnlTextureMtx.MtxScale.Y;

                    NotifyPropertyChanged();
                }
            }, TargetTexMap, TargetTexMaps);
        }
        #endregion
        #endregion

        #region ISceneModifyListener メンバ
        /// <summary>
        /// シーン変更イベントハンドラ
        /// </summary>
        public override void OnSceneModifyHandler(object sender, SceneModifyEventArgs e)
        {
            if (e.Target == SceneModifyEventArgs.Kind.SelectedSetModify)
            {
                using (new GUIUpdating(this))
                {
                    UpdateProperty();
                }
            }
            else if (e.Target == SceneModifyEventArgs.Kind.PaneAnimAddRemove ||
                     e.Target == SceneModifyEventArgs.Kind.PaneAnimModify)
            {
                UpdateAnimationMark();
            }
        }
        #endregion

        private void Event_fudProjectionScale_OnFVec2Edit(object sender, FVec2EditEventArgs args)
        {
            if (IsGUIUpdating) { return; }

            MultiEdit_((obj) => {
                TexMap texMap = obj as TexMap;

                // 変更された項目だけを書き換えます
                FVec2 newValue = new FVec2();
                newValue.X = args.Name.Contains("X") ? args.Value.X : texMap.TexGen.ProjectionScale.X;
                newValue.Y = args.Name.Contains("Y") ? args.Value.Y : texMap.TexGen.ProjectionScale.Y;

                texMap.TexGen.ProjectionScale = newValue;
                NotifyPropertyChanged();
            }, TargetTexMap, TargetTexMaps);
        }

        private void Event_fudProjectionTrans_OnFVec2Edit(object sender, FVec2EditEventArgs args)
        {
            if (IsGUIUpdating) { return; }

            MultiEdit_((obj) => {
                TexMap texMap = obj as TexMap;

                // 変更された項目だけを書き換えます
                FVec2 newValue = new FVec2();
                newValue.X = args.Name.Contains("X") ? args.Value.X : texMap.TexGen.ProjectionOffset.X;
                newValue.Y = args.Name.Contains("Y") ? args.Value.Y : texMap.TexGen.ProjectionOffset.Y;

                texMap.TexGen.ProjectionOffset = newValue;
                NotifyPropertyChanged();
            }, TargetTexMap, TargetTexMaps);
        }

        private void Event_chkAutoScale_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            bool val = _chkAutoScale.Checked;
            MultiEdit_((obj) => {
                TexMap texMap = obj as TexMap;
                texMap.TexGen.IsFittingLayoutSizeEnabled = val;
                NotifyPropertyChanged();
            }, TargetTexMap, TargetTexMaps);
        }

        private void Event_chkAutoScalePaneSize_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            bool val = _chkAutoScalePaneSize.Checked;
            MultiEdit_((obj) => {
                TexMap texMap = obj as TexMap;
                texMap.TexGen.IsFittingPaneSizeEnabled = val;
                NotifyPropertyChanged();
            }, TargetTexMap, TargetTexMaps);
        }

        private void Event_chkAdjustProjectionPaneSR_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            bool val = _chkAdjustProjectionPaneSR.Checked;
            MultiEdit_((obj) => {
                TexMap texMap = obj as TexMap;
                texMap.TexGen.IsAdjustProjectionPaneSREnabled = val;
                NotifyPropertyChanged();
            }, TargetTexMap, TargetTexMaps);
        }
    }

    #region MaterialTextureEditEvent

    /// <summary>
    /// イベント種別
    /// </summary>
    public enum MaterialTextureEditEventKind
    {
        None     = 0x0000,

        Scale_U  = 0x0001,
        Scale_V  = 0x0002,
        Scale_UV = Scale_U | Scale_V,

        Rotate   = 0x0004,

        Trans_U  = 0x0008,
        Trans_V  = 0x0010,
        Trans_UV = Trans_U | Trans_V,

        Reset    = Scale_UV | Rotate | Trans_UV,
    }

    /// <summary>
    /// イベントパラメータ型
    /// </summary>
    public sealed class MaterialTextureEditEventArgs : EventArgs
    {
        private readonly MaterialTextureEditEventKind _kind = MaterialTextureEditEventKind.None;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public MaterialTextureEditEventArgs(MaterialTextureEditEventKind kind)
        {
            _kind = kind;
        }

        /// <summary>
        ///
        /// </summary>
        public MaterialTextureEditEventKind Kind
        {
            get { return _kind; }
        }
    }
    #endregion MaterialTextureEditEvent
}
